/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.module.simple.SimpleModuleConfig;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public class FileStorageConfiguration {
    private final ModuleConfiguration moduleConfiguration;

    public FileStorageConfiguration(Map<String, Setting> settings) {
        this.moduleConfiguration = new SimpleModuleConfig(settings);
    }

    public FileStorageConfiguration(ModuleConfiguration moduleConfiguration) {
        this.moduleConfiguration = moduleConfiguration;
    }

    public String getInstanceId() {
        if (this.moduleConfiguration instanceof ModuleConfigurationImpl) {
            return ((ModuleConfigurationImpl)this.moduleConfiguration).getInstanceId();
        }
        return null;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public String getEndpoint() {
        return this.moduleConfiguration.getSettingValue("fileStorageEndpointUrl").asString("");
    }

    public String getRegion() {
        return this.moduleConfiguration.getSettingValue("fileStorageCloudRegion").asString("");
    }

    public String getCredentialsKey() {
        return this.moduleConfiguration.getSettingValue("fileStorageCredentialsKey").asString("");
    }

    public String getCredentialsSecret() {
        return this.moduleConfiguration.getSettingValue("fileStorageCredentialsSecret").asString("");
    }

    public S3Client buildS3Client() {
        S3ClientBuilder builder = S3Client.builder();
        String endpointUrl = this.getEndpoint();
        if (!StringUtil.isNullOrEmpty(endpointUrl)) {
            builder.endpointOverride(URI.create(endpointUrl));
            if (!endpointUrl.contains("amazonaws.com")) {
                builder.forcePathStyle(Boolean.valueOf(true));
            }
        }
        if (!StringUtil.isNullOrEmpty(this.getRegion())) {
            builder.region(Region.of((String)this.getRegion()));
        } else {
            builder.region(Region.US_EAST_1);
        }
        return (S3Client)((S3ClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getCredentialsKey(), (String)this.getCredentialsSecret())))).build();
    }

    public S3Presigner buildS3Presigner() {
        S3Presigner.Builder builder = S3Presigner.builder();
        String endpointUrl = this.getEndpoint();
        if (!StringUtil.isNullOrEmpty(endpointUrl)) {
            builder.endpointOverride(URI.create(endpointUrl));
            if (!endpointUrl.contains("amazonaws.com")) {
                builder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
            }
        }
        if (!StringUtil.isNullOrEmpty(this.getRegion())) {
            builder.region(Region.of((String)this.getRegion()));
        } else {
            builder.region(Region.US_EAST_1);
        }
        return builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.getCredentialsKey(), (String)this.getCredentialsSecret()))).build();
    }
}

