/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.core.filestorage.FileStorageConfiguration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import software.amazon.awssdk.services.s3.S3Client;

public class FileStorageConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageConnectionTester.class);

    public FileStorageConnectionTester(BundleContext bundleContext) {
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        if (moduleInstance == null) {
            return false;
        }
        if (!"backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId())) {
            return false;
        }
        return "file_storage".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performConnectionTest moduleInstance=..., testData=...");
        try {
            FileStorageConfiguration configuration = new FileStorageConfiguration(moduleInstance.getConfiguration());
            try (S3Client s3Client = configuration.buildS3Client();){
                s3Client.listBuckets();
            }
        }
        catch (Throwable ex) {
            throw new ConnectionTestException(ex);
        }
    }
}

