/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.FileStoreItems;
import de.virtimo.bpc.api.filestorage.exception.FileStorageIndexPreparationException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreBadSortQueryException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcQueryBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcSortBuilder;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.core.filestorage.FileStoreItemFactory;
import de.virtimo.bpc.core.utils.StoragePersistenceQueryUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

class FileStoragePersistenceHandler {
    private static final Logger LOGGER = LogManager.getLogger(FileStoragePersistenceHandler.class);
    private static final Object PREPARE_BPC_FILE_STORAGE_INDEX_LOCK = new Object();
    private static final String INDEX_NAME = "bpc-file-storage";
    private final OpenSearchService oss;

    FileStoragePersistenceHandler(OpenSearchService oss) {
        this.oss = oss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexIfMissing() throws FileStorageIndexPreparationException {
        LOGGER.info("createIndexIfMissing indexName=INDEX_NAME");
        Object object = PREPARE_BPC_FILE_STORAGE_INDEX_LOCK;
        synchronized (object) {
            try {
                BpcIndexState indexState = this.oss.getIndexState(INDEX_NAME);
                indexState.prepareUsing(oss -> oss.getManagedIndicesHandler().createManagedIndex(INDEX_NAME));
            }
            catch (Exception ex) {
                throw new FileStorageIndexPreparationException(INDEX_NAME, ex);
            }
        }
    }

    void saveFileStoreItem(FileStoreItem fileStoreItem) throws StoreItemJsonException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStorageIndexPreparationException {
        LOGGER.info("saveFileStoreItem fileStoreItem=...");
        this.createIndexIfMissing();
        String itemId = fileStoreItem.getId();
        String content = fileStoreItem.asJsonString();
        IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(content, (MediaType)XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.oss.index(indexRequest, RequestOptions.DEFAULT);
    }

    FileStoreItem loadFileStoreItem(String itemId) throws OpenSearchRelatedException, FileStoreItemNotFoundException, OpenSearchIndexNotFoundException, FileStorageIndexPreparationException {
        LOGGER.info("loadFileStoreItem itemId={}", (Object)itemId);
        this.createIndexIfMissing();
        GetRequest getRequest = ((GetRequest)new GetRequest().index(INDEX_NAME)).id(itemId);
        GetResponse response = this.oss.get(getRequest, RequestOptions.DEFAULT);
        if (!response.isExists()) {
            throw new FileStoreItemNotFoundException(itemId);
        }
        return FileStoreItemFactory.create(response.getId(), response.getSourceAsMap());
    }

    FileStoreItems loadFileStoreItems(Integer start, Integer limit, String fileStorageConnectionId, String bucket, String sort, UserSession userSession) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException, OpenSearchIndexMappingNotFoundException, FileStorageIndexPreparationException, FileStoreBadSortQueryException {
        LOGGER.info("loadFileStoreItems fileStorageConnectionId={}, bucket={}, start={}, limit={}, userSession=...", (Object)fileStorageConnectionId, (Object)bucket, (Object)start, (Object)limit);
        this.createIndexIfMissing();
        BpcIndexMapping indexMapping = new BpcIndexMapping(this.oss.getMappingMetaData(INDEX_NAME));
        SearchSourceBuilder ssb = new SearchSourceBuilder().from(start).size(limit).version(true).trackTotalHitsUpTo(Integer.MAX_VALUE);
        ArrayList<QueryBuilder> filterQueries = new ArrayList<QueryBuilder>();
        if (!StringUtil.isNullOrEmpty(fileStorageConnectionId)) {
            filterQueries.add(QueryBuilders.termQuery("objectStoreReference.backendConnectionId", fileStorageConnectionId));
        }
        if (!StringUtil.isNullOrEmpty(bucket)) {
            filterQueries.add(QueryBuilders.termQuery("objectStoreReference.bucket", bucket));
        }
        filterQueries.add(StoragePersistenceQueryUtil.getQueryBuilderForSession(userSession));
        QueryBuilder osQuery = new BpcQueryBuilder().addSkipPercolatorDocumentsQuery().addQueryBuilders(filterQueries).buildAsBoolFilterQuery();
        ssb.query(osQuery);
        List<SortBuilder> groupSortBuilders = BpcSortBuilder.init(indexMapping).addSort("objectStoreReference.backendConnectionId", "ASC").addSort("objectStoreReference.bucket", "ASC").build();
        for (SortBuilder sortBuilder : groupSortBuilders) {
            ssb.sort(sortBuilder);
        }
        if (!StringUtil.isNullOrEmpty(sort)) {
            List<SortBuilder> sortBuilders = null;
            try {
                sortBuilders = BpcSortBuilder.init(indexMapping).addSortFromJsonArray(sort).build();
            }
            catch (IOException e) {
                throw new FileStoreBadSortQueryException(e);
            }
            for (SortBuilder sortBuilder : sortBuilders) {
                ssb.sort(sortBuilder);
            }
        }
        SearchRequest searchRequest = new SearchRequest().indices(INDEX_NAME).source(ssb);
        SearchResponse searchResponse = this.oss.search(searchRequest, RequestOptions.DEFAULT);
        FileStoreItems storeItems = new FileStoreItems(start, limit, searchResponse.getHits().getTotalHits().value());
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            FileStoreItem fileItem = FileStoreItemFactory.create(hit.getId(), hit.getSourceAsMap());
            storeItems.add(fileItem);
        }
        return storeItems;
    }

    void deleteFileStoreItem(String itemId) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStoreItemNotFoundException, FileStorageIndexPreparationException {
        LOGGER.info("deleteFileStoreItem itemId={}", (Object)itemId);
        this.createIndexIfMissing();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(itemId);
        DeleteResponse deleteResponse = this.oss.delete(deleteRequest, RequestOptions.DEFAULT);
        if (deleteResponse.status() == RestStatus.NOT_FOUND) {
            throw new FileStoreItemNotFoundException(itemId);
        }
    }
}

