/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.filestorage.FileStorageService;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.FileStoreItemPutDto;
import de.virtimo.bpc.api.filestorage.FileStoreItems;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.filestorage.exception.FileStorageIndexPreparationException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreBadSortQueryException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemExistsException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemNotFoundException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreItemRightsException;
import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.filestorage.FileStorageConfiguration;
import de.virtimo.bpc.core.filestorage.FileStoragePersistenceHandler;
import de.virtimo.bpc.core.filestorage.FileStoreItemFactory;
import de.virtimo.bpc.util.UUIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.zip.CRC32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;

public class FileStorageServiceImpl
implements BpcService,
FileStorageService {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageServiceImpl.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker = null;
    private final int PRESIGN_URL_VALIDITY_MINUTES = 5;

    public FileStorageServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        if (bundleContext != null) {
            this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
            this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        } else {
            LOGGER.warn("BundleContext is null? Hopefully this is just an integration test.");
        }
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public FileStoreItems getItems(Integer start, Integer limit, String backendConnectionId, String bucket, String sort, @NotNull UserSession userSession) throws ServiceNotFoundException, OpenSearchIndexNotFoundException, OpenSearchRelatedException, OpenSearchIndexMappingNotFoundException, FileStorageIndexPreparationException, FileStoreBadSortQueryException {
        LOGGER.info("getItems start={}, limit={}, backendConnectionId={}, bucket={}, userSession=...", (Object)start, (Object)limit, (Object)backendConnectionId, (Object)bucket);
        if (start == null || start < 0) {
            start = 0;
            LOGGER.debug("No 'start' parameter given or out of range. Set start to {}", (Object)start);
        }
        if (limit == null || limit < 0 || limit > 10000) {
            limit = 10000;
            LOGGER.debug("No 'limit' parameter given or out of range. Set limit to {}", (Object)limit);
        }
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        return persistenceHandler.loadFileStoreItems(start, limit, backendConnectionId, bucket, sort, userSession);
    }

    @Override
    public FileStoreItem getItem(String itemId, UserSession userSession) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStoreItemNotFoundException, FileStoreItemRightsException, FileStorageIndexPreparationException {
        LOGGER.info("getItem itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        return storeItem;
    }

    @Override
    public URL getPresignedDownloadUrl(String itemId, UserSession userSession) throws OpenSearchIndexNotFoundException, OpenSearchRelatedException, FileStorageIndexPreparationException, FileStoreItemNotFoundException, ServiceNotFoundException, FileStoreItemRightsException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("getPresignedDownloadUrl itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isReadableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        FileStorageConfiguration backendConnection = this.getFileStorageConnectionConfig(objectStoreReference.backendConnectionId());
        try (S3Presigner s3Presigner = backendConnection.buildS3Presigner();){
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(objectStoreReference.bucket()).key(objectStoreReference.fileKey()).responseContentDisposition(String.format("attachment; filename=\"%s\"", storeItem.getFilename())).responseContentType(storeItem.getContentType()).build();
            GetObjectPresignRequest presignGetRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(5L)).getObjectRequest(getObjectRequest).build();
            URL uRL = s3Presigner.presignGetObject(presignGetRequest).url();
            return uRL;
        }
    }

    @Override
    public FileStoreItem createItem(UploadedFile file, String bucket, String backendConnectionId, ItemRestriction readRestriction, ItemRestriction writeRestriction, String creatorServiceId, UserSession userSession, boolean performUserRestrictionChecks) throws SystemException {
        LOGGER.info("createItem file={}, bucket={}, backendConnectionId={}, readRestriction=..., writeRestriction=..., userSession=...", (Object)file.getFileName(), (Object)bucket, (Object)backendConnectionId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        String itemId = UUIDGenerator.randomUUID();
        try {
            FileStoreItem existingStoreItem = persistenceHandler.loadFileStoreItem(itemId);
            if (existingStoreItem != null) {
                throw new FileStoreItemExistsException(itemId);
            }
        }
        catch (FileStoreItemNotFoundException existingStoreItem) {
            // empty catch block
        }
        FileStorageConfiguration fileStorageConnectionConfig = this.getFileStorageConnectionConfig(backendConnectionId);
        ZonedDateTime creationDate = ZonedDateTime.now();
        FileSizeAndChecksum fileSizeAndChecksum = this.getFileSizeAndCrc32(file);
        ObjectStoreReference objectStoreReference = new ObjectStoreReference(backendConnectionId, bucket, itemId);
        FileStoreItem fileItem = FileStoreItem.withId(itemId).withCreator(userSession.getLoginName()).withCreatorServiceId(creatorServiceId).withCreationDate(creationDate).withModificationDate(creationDate).withFilename(file.getFileName()).withContentType(file.getContentType().toString()).withFilesize(fileSizeAndChecksum.fileSize()).withChecksumCrc32(fileSizeAndChecksum.crc32()).withReadRestriction(readRestriction).withWriteRestriction(writeRestriction).withObjectStoreReference(objectStoreReference).build();
        if (performUserRestrictionChecks) {
            this.validateFileRestrictionsOnCreate(fileItem, userSession);
        }
        try (S3Client s3Client = fileStorageConnectionConfig.buildS3Client();){
            this.uploadFileToS3(s3Client, file, bucket, itemId, file.getContentType().toString());
            try {
                persistenceHandler.saveFileStoreItem(fileItem);
            }
            catch (Exception e) {
                this.deleteFileFromS3(s3Client, bucket, itemId);
                throw e;
            }
        }
        return fileItem;
    }

    @Override
    public FileStoreItem updateFile(String itemId, UploadedFile file, UserSession userSession) throws SystemException {
        LOGGER.info("updateFile itemId={}, file={}, userSession=...", (Object)itemId, (Object)file.getFileName());
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isWriteableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        FileSizeAndChecksum sizeAndChecksum = this.getFileSizeAndCrc32(file);
        ObjectStoreReference objectStoreReference = storeItem.getObjectStoreReference();
        FileStorageConfiguration backendConnection = this.getFileStorageConnectionConfig(objectStoreReference.backendConnectionId());
        try (S3Client s3Client = backendConnection.buildS3Client();){
            this.uploadFileToS3(s3Client, file, objectStoreReference.bucket(), objectStoreReference.fileKey(), storeItem.getContentType());
        }
        FileStoreItem updatedFileItem = FileStoreItemFactory.createUpdatedFileItem(storeItem, file.getFileName(), file.getContentType().toString(), sizeAndChecksum.fileSize(), sizeAndChecksum.crc32());
        persistenceHandler.saveFileStoreItem(updatedFileItem);
        return updatedFileItem;
    }

    @Override
    public FileStoreItem updateItemMetadata(String itemId, FileStoreItemPutDto fileStoreItemPutDto, UserSession userSession) throws SystemException {
        LOGGER.info("updateItemMetadata itemId={}, fileStoreItemPutDto={}, userSession=...", (Object)itemId, (Object)fileStoreItemPutDto);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (!storeItem.isWriteableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        if (fileStoreItemPutDto.readRestriction != null) {
            this.validateFileRestriction(fileStoreItemPutDto.readRestriction, userSession, "The user does not fulfill updated Read Restrictions.");
        }
        if (fileStoreItemPutDto.writeRestriction != null) {
            this.validateFileRestriction(fileStoreItemPutDto.writeRestriction, userSession, "The user does not fulfill updated Write Restrictions.");
        }
        FileStoreItem updatedFileItem = FileStoreItemFactory.createUpdatedFileItem(storeItem, fileStoreItemPutDto);
        persistenceHandler.saveFileStoreItem(updatedFileItem);
        return updatedFileItem;
    }

    @Override
    public void deleteItem(String itemId, UserSession userSession, boolean performUserRestrictionChecks) throws ServiceNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, FileStoreItemNotFoundException, FileStoreItemRightsException, FileStorageIndexPreparationException, ModuleNotFoundException, ModuleInstanceNotFoundException, FileStoreConnectionException {
        LOGGER.info("deleteItem itemId={}, userSession=...", (Object)itemId);
        FileStoragePersistenceHandler persistenceHandler = new FileStoragePersistenceHandler(this.getOpenSearchService());
        FileStoreItem storeItem = persistenceHandler.loadFileStoreItem(itemId);
        if (performUserRestrictionChecks && !storeItem.isDeletableBy(userSession)) {
            throw new FileStoreItemRightsException(itemId);
        }
        ObjectStoreReference objectStoreRef = storeItem.getObjectStoreReference();
        FileStorageConfiguration fileStorageConnectionConfig = this.getFileStorageConnectionConfig(objectStoreRef.backendConnectionId());
        try (S3Client s3Client = fileStorageConnectionConfig.buildS3Client();){
            this.deleteFileFromS3(s3Client, objectStoreRef.bucket(), objectStoreRef.fileKey());
        }
        persistenceHandler.deleteFileStoreItem(itemId);
    }

    private FileSizeAndChecksum getFileSizeAndCrc32(UploadedFile file) throws SystemException {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        long totalBytes = 0L;
        try (InputStream instream = file.getInputStream();){
            int bytesRead;
            while ((bytesRead = instream.read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
                totalBytes += (long)bytesRead;
            }
        }
        catch (IOException e) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_INTERNAL_ERROR, "Error while reading uploaded file: " + e.getMessage());
        }
        return new FileSizeAndChecksum(totalBytes, String.format("%08x", crc.getValue()));
    }

    private void validateFileRestrictionsOnCreate(FileStoreItem fileStoreItem, UserSession userSession) throws SystemException {
        this.validateFileRestriction(fileStoreItem.getReadRestriction(), userSession, "The user needs read access on the file they create.");
        this.validateFileRestriction(fileStoreItem.getWriteRestriction(), userSession, "The user needs write access on the file they create.");
    }

    private void validateFileRestriction(ItemRestriction itemRestriction, UserSession userSession, String message) throws SystemException {
        if (itemRestriction == null || !itemRestriction.isValid() || !itemRestriction.hasAccess(userSession)) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, message);
        }
    }

    private FileStorageConfiguration getFileStorageConnectionConfig(String backendConnectionId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("getBackendConnectionConfiguration deploymentSystemId={}", (Object)backendConnectionId);
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        List<ModuleInstance> fileBackendConnections = backendConnectionsModule.getModuleInstancesByInstanceType("file_storage");
        Optional<ModuleInstance> fileBackendConnection = fileBackendConnections.stream().filter(c -> c.getModuleId().equals(backendConnectionId)).findFirst();
        if (fileBackendConnection.isEmpty()) {
            throw new ModuleInstanceNotFoundException("backendconnection", backendConnectionId);
        }
        return new FileStorageConfiguration(fileBackendConnection.get().getConfiguration());
    }

    private void uploadFileToS3(S3Client s3Client, UploadedFile file, String bucket, String fileKey, String contentType) throws FileStoreConnectionException {
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket).key(fileKey).contentType(contentType).build();
        try {
            s3Client.putObject(putObjectRequest, file.getTemporaryContentFile().toPath());
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e);
        }
    }

    private void deleteFileFromS3(S3Client s3Client, String bucket, String fileKey) throws FileStoreConnectionException {
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(bucket).key(fileKey).build();
        try {
            s3Client.deleteObject(deleteObjectRequest);
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e);
        }
    }

    private record FileSizeAndChecksum(long fileSize, String crc32) {
    }
}

