/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.filestorage.FileStorageService;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.FileStoreItemPutDto;
import de.virtimo.bpc.api.filestorage.FileStoreItems;
import de.virtimo.bpc.api.filestorage.FileUploadedResponseDto;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.ItemRestrictionFactory;
import de.virtimo.bpc.core.multipart.UploadedFileImpl;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

@Path(value="file-storage")
@Tag(name="File Storage API", description="File storage endpoints provide functionality to store files and binary data through configured file storage backend connections.\n")
public class FileStorageEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<FileStorageService> fileStorageServiceTracker;

    public FileStorageEndpoint(BundleContext bundleContext) {
        LOGGER.info("StatusEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.fileStorageServiceTracker = new BpcServicesTracker<FileStorageService>(this.bundleContext, FileStorageService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="file/{fileId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileStoreItem.class))}), @ApiResponse(responseCode="400", description="File ID parameter is missing."), @ApiResponse(responseCode="403", description="The user has no read permission for the file."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @OperationDescription(summary="Retrieves metadata of a file in the file storage.", description="Retrieves metadata of a file in the file storage.")
    @ReturnDescription(value="Returns the metadata of the requested file in JSON format.")
    public Response getFileInformation(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("getFileInformation fileId={}", (Object)fileId);
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        try {
            FileStoreItem fileItem = this.fileStorageServiceTracker.getService().getItem(fileId, userSession);
            return Response.ok((Object)fileItem, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get file store item failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="files")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileStoreItems.class))})})
    @OperationDescription(summary="Retrieves a list of file metadata in the file storage.", description="Retrieves a list of file metadata in the file storage.")
    @ReturnDescription(value="Returns a JSON array containing metadata for files stored in the object store bucket.")
    public Response getFileList(@Parameter(description="The file storage backend connection ID (optional)") @QueryParam(value="backendConnectionId") @DefaultValue(value="") String backendConnectionId, @Parameter(description="The object stores bucket name (optional)") @QueryParam(value="bucket") @DefaultValue(value="") String bucket, @Parameter(description="first record to be read (optional, default = 0)") @QueryParam(value="start") @DefaultValue(value="0") Integer start, @Parameter(description="number of records to read (optional, default = 1000, max. 10.000)") @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @Parameter(description="sort instruction (ExtJS-JSON) (optional)") @QueryParam(value="sort") @DefaultValue(value="") String sort, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("getFileInformation backendConnectionId={}, bucket={}, start={}, limit={}", (Object)backendConnectionId, (Object)bucket, (Object)start, (Object)limit);
        try {
            FileStoreItems fileItems = this.fileStorageServiceTracker.getService().getItems(start, limit, backendConnectionId, bucket, sort, userSession);
            return Response.ok((Object)fileItems, (String)"application/json").build();
        }
        catch (Exception e) {
            LOGGER.error("get file store items failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="download/{fileId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="307", description="Redirect to download"), @ApiResponse(responseCode="400", description="File ID parameter is missing."), @ApiResponse(responseCode="403", description="The user has no read permission to request a download."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @OperationDescription(summary="Downloads the requested file from the file storage.", description="Downloads the requested file from the file storage.\n\nThis is done by redirecting to a presigned download URL.\n")
    @ReturnDescription(value="The requested file as a download.")
    public Response downloadFile(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("downloadFile fileId={}", (Object)fileId);
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        try {
            URL presignedUrl = this.fileStorageServiceTracker.getService().getPresignedDownloadUrl(fileId, userSession);
            return Response.temporaryRedirect((URI)presignedUrl.toURI()).build();
        }
        catch (SystemException | URISyntaxException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="download-url/{fileId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Download URL", content={@Content(mediaType="application/json", schema=@Schema(implementation=DownloadUrlDto.class))}), @ApiResponse(responseCode="400", description="File ID parameter is missing."), @ApiResponse(responseCode="403", description="The user has no read permission to request a download."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @OperationDescription(summary="Get a download URL for the requested file from the file storage.", description="Get a download URL for the requested file from the file storage.\n\nThe return body is a presigned download URL to the file.\n")
    @ReturnDescription(value="A temporary valid download url for the requested file.")
    public Response getDownloadURL(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("getDownloadURL fileId={}", (Object)fileId);
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        try {
            URL presignedUrl = this.fileStorageServiceTracker.getService().getPresignedDownloadUrl(fileId, userSession);
            DownloadUrlDto result = new DownloadUrlDto(presignedUrl.toString());
            return Response.ok((Object)result).build();
        }
        catch (SystemException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="File has been stored", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileUploadedResponseDto.class))}), @ApiResponse(responseCode="400", description="Missing form data content"), @ApiResponse(responseCode="403", description="The user does not fulfill the read or write restrictions."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @RequestBody(description="The multipart request containing the file and metadata.", required=true, content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=FileUploadForm.class))})
    @OperationDescription(summary="Create a file in the file storage.", description="Create a file in the file storage.\n\nThe file and necessary metadata is passed via multipart form data.\nRequired are the following form fields:\n\n* `file`: the uploaded file\n* `bucket`: the name of the bucket to upload to\n* `backendConnectionId`: the ID of the configured file storage backend connection\n* `readRestriction`: the read restriction\n* `writeRestriction`: the write restriction\n\nAdditionally, a form field `creatorServiceId` can be specified, referring to the service instance that triggers the upload.\n\nThe read and write restrictions use the following format:\n[source,json]\n----\n{\n     \"user\": \"hans_schmidt\",\n     \"organisations\": [ \"DEFAULT\" ],\n     \"roles\": [ \"expert\", \"advanced\", \"beginner\" ],\n     \"rights\": [ \"loadModule_monitor\" ]\n}\n----\n\nIf a user is specified in a restriction, all other fields are ignored, and only this user fulfils the restriction.\n\nNote, the uploader needs to fulfill both read and write restrictions.\n")
    @ReturnDescription(value="The created file metadata, including a success flag.")
    public Response uploadFile(@Parameter(hidden=true) List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("uploadFile attachments=..");
        UploadedFileImpl uploadedFile = null;
        if (attachments == null || attachments.isEmpty()) {
            return this.createValidationErrorResponse("Missing Multipart Form-Data with file and metadata", hh);
        }
        try {
            Attachment fileAttachment = this.getSingleAttachmentsOfName(attachments, "file");
            String bucketName = this.extractStringValueFromAttachment(attachments, "bucket");
            String backendConnectionId = this.extractStringValueFromAttachment(attachments, "backendConnectionId");
            ItemRestriction readRestriction = this.extractItemRestrictionFromAttachment(attachments, "readRestriction");
            ItemRestriction writeRestriction = this.extractItemRestrictionFromAttachment(attachments, "writeRestriction");
            String creatorServiceId = this.extractOptionalStringValueFromAttachment(attachments, "creatorServiceId");
            uploadedFile = new UploadedFileImpl(fileAttachment);
            FileStoreItem createdItem = this.fileStorageServiceTracker.getService().createItem(uploadedFile, bucketName, backendConnectionId, readRestriction, writeRestriction, creatorServiceId, userSession, true);
            FileUploadedResponseDto responseDto = new FileUploadedResponseDto(true, createdItem);
            Response response = Response.ok((Object)responseDto).build();
            this.cleanupUploadedFile(uploadedFile);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Create file store item failed", (Throwable)e);
            Response response = ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
            return response;
        }
        finally {
            this.cleanupUploadedFile(uploadedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="upload/{fileId}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="File has been updated", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileStoreItem.class))}), @ApiResponse(responseCode="400", description="Missing file ID parameter or file upload."), @ApiResponse(responseCode="403", description="The user does not fulfill the write restrictions."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @RequestBody(description="The multipart request containing the new file.", required=true, content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=FileUploadReplaceForm.class))})
    @OperationDescription(summary="Replaces an existing file in the file storage.", description="Replaces an existing file in the file storage.\n\nThe file is passed via multipart form data.\n")
    @ReturnDescription(value="The updated file metadata.")
    public Response replaceFile(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, @Parameter(hidden=true) List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("replaceFile attachments=..");
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        if (attachments == null || attachments.size() != 1) {
            return this.createValidationErrorResponse("The multipart form data should contain only the file.", hh);
        }
        UploadedFileImpl uploadedFile = null;
        try {
            uploadedFile = new UploadedFileImpl(attachments.get(0));
            FileStoreItem updatedFileItem = this.fileStorageServiceTracker.getService().updateFile(fileId, uploadedFile, userSession);
            Response response = Response.ok((Object)updatedFileItem).build();
            this.cleanupUploadedFile(uploadedFile);
            return response;
        }
        catch (Exception e) {
            try {
                LOGGER.error("Update file failed", (Throwable)e);
                Response response = ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                this.cleanupUploadedFile(uploadedFile);
                return response;
            }
            catch (Throwable throwable) {
                this.cleanupUploadedFile(uploadedFile);
                throw throwable;
            }
        }
    }

    @PUT
    @Path(value="file/{fileId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the updated file store item", content={@Content(mediaType="application/json", schema=@Schema(implementation=FileStoreItem.class))}), @ApiResponse(responseCode="400", description="File ID parameter is missing."), @ApiResponse(responseCode="403", description="The user has no write permission to perform deletion."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @OperationDescription(summary="Updates the metadata of a file in the file storage.", description="Updates the metadata of a file in the file storage.\n\nUpdates can be applied to 'File Name', 'Read Restrictions' and 'Write Restrictions'.\nFields in the PUT-DTO that are left out will not be updated.\n")
    public Response changeFileMetadata(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, FileStoreItemPutDto fileStoreItemPutDto, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("changeFileMetadata fileStoreItemPutDto=..");
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        try {
            FileStoreItem updatedItem = this.fileStorageServiceTracker.getService().updateItemMetadata(fileId, fileStoreItemPutDto, userSession);
            return Response.ok((Object)updatedItem).build();
        }
        catch (Exception e) {
            LOGGER.error("delete file store item failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="file/{fileId}")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Deletion was successful."), @ApiResponse(responseCode="400", description="File ID parameter is missing."), @ApiResponse(responseCode="403", description="The user has no write permission to perform deletion."), @ApiResponse(responseCode="404", description="The requested file does not exist.")})
    @OperationDescription(summary="Deletes a file in the file storage.", description="Deletes a file in the file storage.")
    public Response deleteFile(@Parameter(description="The File ID") @PathParam(value="fileId") String fileId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOGGER.debug("deleteFile fileId={}", (Object)fileId);
        if (StringUtil.isNullOrEmpty(fileId)) {
            return this.createValidationErrorResponse("Missing Parameter: fileId", hh);
        }
        try {
            this.fileStorageServiceTracker.getService().deleteItem(fileId, userSession, true);
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOGGER.error("delete file store item failed", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Attachment getSingleAttachmentsOfName(List<Attachment> attachments, @NotNull String name) throws SystemException {
        List<Attachment> attachmentsOfName = attachments.stream().filter(a -> name.equals(a.getContentDisposition().getParameters().get("name"))).toList();
        if (attachmentsOfName.isEmpty()) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, String.format("Missing Multipart Form-Data element '%s'", name));
        }
        if (attachmentsOfName.size() > 1) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, String.format("Duplicate Multipart Form-Data element '%s' is not permitted", name));
        }
        return attachmentsOfName.get(0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String extractStringValueFromAttachment(List<Attachment> attachments, @NotNull String name) throws SystemException {
        Attachment attachment = this.getSingleAttachmentsOfName(attachments, name);
        try (InputStream input = attachment.getDataHandler().getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, String.format("Failed to extract Multipart Form-Data element '%s': %s", name, e.getMessage()));
        }
    }

    private String extractOptionalStringValueFromAttachment(List<Attachment> attachments, @NotNull String name) {
        try {
            return this.extractStringValueFromAttachment(attachments, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ItemRestriction extractItemRestrictionFromAttachment(List<Attachment> attachments, @NotNull String name) throws SystemException {
        String restrctionJsonString = this.extractStringValueFromAttachment(attachments, name);
        try {
            Map<String, Object> restrictionMap = JsonUtil.getInstance().jsonStringAsMap(restrctionJsonString);
            return ItemRestrictionFactory.create(restrictionMap);
        }
        catch (IOException e) {
            throw new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, String.format("Failed to extract Multipart Form-Data element '%s': %s", name, e.getMessage()));
        }
    }

    private Response createValidationErrorResponse(String message, HttpHeaders hh) {
        SystemException sex = new SystemException((ErrorCode)BpcErrorCode.FILE_STORAGE_BAD_REQUEST, message);
        return ErrorResponse.forException(sex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
    }

    private void cleanupUploadedFile(UploadedFileImpl uploadedFile) {
        if (uploadedFile != null) {
            try {
                uploadedFile.cleanUp();
            }
            catch (Exception ex) {
                LOGGER.warn("Clean up of uploaded file failed", (Throwable)ex);
            }
        }
    }

    public record DownloadUrlDto(String url) {
    }

    public static class FileUploadReplaceForm {
        @Schema(type="string", format="binary", description="The new file to replace the current file with.")
        public InputStream file;
    }

    public static class FileUploadForm {
        @Schema(type="string", format="binary", description="The file to upload.")
        public InputStream file;
        @Schema(type="string", description="Name of the bucket", example="my-storage-bucket")
        public String bucket;
        @Schema(type="string", description="ID of the configured file storage backend connection to use", example="1111222233334")
        public String backendConnectionId;
        public ItemRestriction readRestriction;
        public ItemRestriction writeRestriction;
        @Schema(type="string", description="Optional ID of the service that uses this endpoint (e.g. a Log-Service instance)")
        public String creatorServiceId;
    }
}

