/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.frontendlogging;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingException;
import de.virtimo.bpc.core.frontendlogging.FrontendLoggingManager;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.osgi.framework.BundleContext;

public class FrontendLoggingManagerImpl
implements FrontendLoggingManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(FrontendLoggingManagerImpl.class);
    private static final String INDEX_ALIAS_NAME = "bpc-frontend-logging";
    private static final Object FRONTEND_LOGGING_INDEX_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final int cleanupPeriodInMinutes;
    private final String deleteEntriesOlderThan;
    private BulkProcessor bulkProcessor = null;
    private final ExecutorService informClientsExecutorService;

    public FrontendLoggingManagerImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.cleanupPeriodInMinutes = coreBundleConfiguration.getSystemPropertyValueAsInt("de.virtimo.bpc.core.frontendlogging.cleanupPeriodInMinutes", 60);
        this.deleteEntriesOlderThan = coreBundleConfiguration.getSystemPropertyValueAsString("de.virtimo.bpc.core.frontendlogging.deleteEntriesOlderThan", "4 weeks ago");
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(bundleContext, CoreBundleService.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.informClientsExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-performance-data-clients-informer"));
        this.startFELoggingIndexCleanupTask();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
        }
        if (this.informClientsExecutorService != null) {
            this.informClientsExecutorService.shutdown();
        }
        this.stopFELoggingIndexCleanupTask();
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFrontendLogData(String sessionId, String userAgent, List<Map<String, String>> logData) throws FrontendLoggingException, ServiceNotFoundException, MaintenanceModeEnabledException {
        LOGGER.info("save frontend log data sessionId=..., userAgent={}, measurements=...", (Object)userAgent);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = FRONTEND_LOGGING_INDEX_LOCK;
        synchronized (object) {
            String indexName;
            try {
                BpcIndexState bpcFrontendLoggingIndexState = oss.getIndexState(INDEX_ALIAS_NAME);
                bpcFrontendLoggingIndexState.prepareUsing(new BpcIndexCreateCallable(){

                    @Override
                    public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException {
                        return oss.getManagedIndicesHandler().createManagedIndex(FrontendLoggingManagerImpl.INDEX_ALIAS_NAME);
                    }
                });
                indexName = bpcFrontendLoggingIndexState.getIndexName();
            }
            catch (Exception ex) {
                throw new FrontendLoggingException((ErrorCode)CoreErrorCode.FRONTEND_LOGGING_FAILED, "Failed to prepare the frontend logging index '${index}'.", MapUtil.mapOf("index", INDEX_ALIAS_NAME), (Throwable)ex);
            }
            if (this.bulkProcessor == null) {
                this.bulkProcessor = this.createBulkProcessor(oss);
            }
            for (Map<String, String> logEntry : logData) {
                HashMap<String, String> singleLog = new HashMap<String, String>();
                singleLog.put("level", logEntry.get("level"));
                singleLog.put("message", logEntry.get("message"));
                singleLog.put("timestampUTC", logEntry.get("timestamp"));
                singleLog.put("sessionId", sessionId);
                this.bulkProcessor.add(new IndexRequest(indexName).source(singleLog));
            }
        }
    }

    private BulkProcessor createBulkProcessor(final OpenSearchService oss) {
        LOGGER.info("createBulkProcessor oss=...");
        RestHighLevelClient osClient = oss.getClient();
        BulkProcessor.Listener listener = new BulkProcessor.Listener(){

            @Override
            public void beforeBulk(long executionId, BulkRequest request) {
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, final BulkResponse bulkResponse) {
                try {
                    final PercolatorsManager percolatorsManager = FrontendLoggingManagerImpl.this.percolatorsManagerTracker.getService();
                    FutureTask<Exception> informClientsFutureTask = new FutureTask<Exception>(new Callable<Exception>(){

                        @Override
                        public Exception call() {
                            try {
                                percolatorsManager.informClientsAboutReplicatedData(oss, FrontendLoggingManagerImpl.INDEX_ALIAS_NAME, bulkResponse);
                                return null;
                            }
                            catch (Exception ex) {
                                LOGGER.error(ex.getMessage(), (Throwable)ex);
                                return ex;
                            }
                        }
                    });
                    FrontendLoggingManagerImpl.this.informClientsExecutorService.execute(informClientsFutureTask);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to inform the frontends about new frontend log data.", (Throwable)ex);
                }
            }

            @Override
            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            }
        };
        return BulkProcessor.builder((request, bulkListener) -> osClient.bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(1000).setFlushInterval(TimeValue.timeValueSeconds(15L)).setConcurrentRequests(1).build();
    }

    private void stopFELoggingIndexCleanupTask() {
        LOGGER.info("stopFrontendLoggingIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_ALIAS_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop/cancel the running cleanup task for the index 'bpc-frontend-logging'.", (Throwable)ex);
        }
    }

    private void startFELoggingIndexCleanupTask() {
        LOGGER.info("startFrontendLoggingIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_ALIAS_NAME, "timestampUTC", this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to schedule the index cleanup task for the index 'bpc-frontend-logging'.", (Throwable)ex);
        }
    }
}

