/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.HttpProxyService;
import de.virtimo.bpc.core.auth.CsrfTokenException;
import de.virtimo.bpc.core.auth.CsrfTokenService;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="httpProxy")
@Tag(name="Http Proxy API", description="These are the endpoints for proxy http requests to other systems.\nThe Http Proxy API supports the following HTTP methods: `GET`, `POST`, `PUT`, `DELETE`, `PATCH` and `OPTIONS`.\n")
public class HttpProxyEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<HttpProxyService> httpProxyServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<CsrfTokenService> csrfTokenServiceTracker;

    public HttpProxyEndpoint(BundleContext bundleContext) {
        LOGGER.info("HttpProxyEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.httpProxyServiceTracker = new BpcServicesTracker<HttpProxyService>(this.bundleContext, HttpProxyService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.csrfTokenServiceTracker = new BpcServicesTracker<CsrfTokenService>(this.bundleContext, CsrfTokenService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private void checkCsrfToken(HttpServletRequest req, UserSession userSession, String instanceId) throws CsrfTokenException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.debug("checkCsrfToken req=..., instanceId={}", (Object)instanceId);
        if (this.httpProxyServiceTracker.getService().getConfig(instanceId).getSettingValue("checkCsrfToken").asBoolean(true) && !this.csrfTokenServiceTracker.getService().isValidRequest(req, userSession)) {
            throw new CsrfTokenException();
        }
    }

    @GET
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP GET on the 'http proxy' backend connection.", description="Perform an HTTP GET on the 'http proxy' backend connection.")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyGet(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") @DefaultValue(value="") String targetUrl, @Context HttpServletRequest req, @Context UriInfo uriInfo, @Context UserSession userSession, @Context HttpHeaders headers) {
        LOGGER.debug("proxyGet : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doGet(instanceId, targetPath, targetUrl, uriInfo, headers, userSession);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP POST on the 'http proxy' backend connection.", description="Perform an HTTP POST on the 'http proxy' backend connection.")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyPost(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") String targetUrl, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOGGER.debug("proxyPost : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doPost(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP PUT on the 'http proxy' backend connection.", description="Perform an HTTP PUT on the 'http proxy' backend connection.")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyPut(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") String targetUrl, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOGGER.debug("proxyPut : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doPut(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP DELETE on the 'http proxy' backend connection.", description="Perform an HTTP DELETE on the 'http proxy' backend connection.")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyDelete(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") String targetUrl, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession) {
        LOGGER.debug("proxyDelete : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doDelete(instanceId, targetPath, targetUrl, uriInfo, headers, userSession);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OPTIONS
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP OPTIONS on the 'http proxy' backend connection.", description="Perform an HTTP OPTIONS on the 'http proxy' backend connection.\n\nNote: As OPTIONS requests are always proxied, an introspection of this endpoint using OPTIONS is not possible.\n")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyOptions(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") String targetUrl, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession) {
        LOGGER.debug("proxyOptions : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doOptions(instanceId, targetPath, targetUrl, uriInfo, headers, userSession);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PATCH
    @Path(value="/{instanceId}{targetPath: (/.*)?}")
    @BpcUserSessionRequired(skipCsrfCheck="true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Resource unavailable:\n\n* One of the used services is not available\n* The backend connections module is not available\n* The backend connections module instance is not available\n"), @ApiResponse(responseCode="500", description="General problem with the backend system"), @ApiResponse(responseCode="503", description="Connection to backend system refused"), @ApiResponse(responseCode="504", description="Connection to backend system timed out")})
    @OperationDescription(summary="Perform an HTTP PATCH on the 'http proxy' backend connection.", description="Perform an HTTP PATCH on the 'http proxy' backend connection.")
    @ReturnDescription(value="The response of the called backend connection")
    public Response proxyPatch(@Parameter(description="the id of the 'http proxy' backend connections instance to use") @PathParam(value="instanceId") String instanceId, @Parameter(description="the path to call on the target system") @PathParam(value="targetPath") @Encoded @DefaultValue(value="") String targetPath, @Parameter(description="optional URL Parameter. Function equals targetPath") @QueryParam(value="targetUrl") String targetUrl, @Context HttpServletRequest req, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Context UserSession userSession, byte[] body) {
        LOGGER.debug("proxyPatch : proxyInstanceId={} uriInfo={} ", (Object)instanceId, (Object)uriInfo);
        try {
            this.checkCsrfToken(req, userSession, instanceId);
            return this.httpProxyServiceTracker.getService().doPatch(instanceId, targetPath, targetUrl, uriInfo, headers, userSession, body);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception backend connection: ", (Throwable)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

