/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpProxyTargetUrl {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyTargetUrl.class);
    private String baseUrl;
    private String targetPath;
    private String targetUrl;
    private MultivaluedMap<String, String> queryParams;

    private HttpProxyTargetUrl() {
    }

    public static HttpProxyTargetUrl withBaseUrl(String baseUrl) {
        HttpProxyTargetUrl builder = new HttpProxyTargetUrl();
        builder.baseUrl = baseUrl;
        return builder;
    }

    public HttpProxyTargetUrl withTargetPath(String targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    public HttpProxyTargetUrl withTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    public HttpProxyTargetUrl withQueryParams(MultivaluedMap<String, String> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public String build() throws HttpProxyException {
        LOGGER.debug("build with baseUrl={}, targetPath={}, targetUrl={}, queryParams={}", (Object)this.baseUrl, (Object)this.targetPath, (Object)this.targetUrl, this.queryParams);
        try {
            String urlString = HttpProxyTargetUrl.prepareUrlParts(this.baseUrl, this.targetPath, this.targetUrl) + HttpProxyTargetUrl.prepareQueryParams(this.queryParams);
            LOGGER.info("Target url: {}", (Object)urlString);
            URL url = new URL(urlString);
            if (Arrays.asList("LOCALHOST", "127.0.0.1").contains(url.getHost().toUpperCase())) {
                try {
                    String realHost = InetAddress.getLocalHost().getHostName();
                    url = url.getRef() != null ? new URL(url.getProtocol(), realHost, url.getPort(), url.getFile() + "#" + url.getRef()) : new URL(url.getProtocol(), realHost, url.getPort(), url.getFile());
                }
                catch (UnknownHostException ex) {
                    throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_ILLEGAL_ACCESS, "No URLs to local interface allowed: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
                }
            }
            LOGGER.info("Final target url: {}", (Object)url);
            return url.toExternalForm();
        }
        catch (MalformedURLException ex) {
            throw new HttpProxyException((ErrorCode)CoreErrorCode.HTTPPROXY_MALFORMED_URL, "Malformed URL: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    private static String prepareUrlParts(String baseUrl, String targetPath, String targetUrl) {
        String concattedUrl;
        LOGGER.debug("prepareUrlParts baseUrl={}, targetPath={}, targetUrl={}", (Object)baseUrl, (Object)targetPath, (Object)targetUrl);
        String string = concattedUrl = baseUrl == null ? "" : baseUrl;
        if (!StringUtil.isNullOrEmpty(targetPath)) {
            concattedUrl = StringUtil.glue(concattedUrl, targetPath, '/');
        }
        if (!StringUtil.isNullOrEmpty(targetUrl)) {
            concattedUrl = StringUtil.glue(concattedUrl, targetUrl, '/');
        }
        return concattedUrl;
    }

    private static String prepareQueryParams(MultivaluedMap<String, String> queryParams) {
        LOGGER.debug("prepareQueryParams queryParams={}", queryParams);
        if (queryParams == null || queryParams.isEmpty()) {
            return "";
        }
        Object paramString = "?";
        for (String theKey : queryParams.keySet()) {
            for (String theValue : (List)queryParams.get((Object)theKey)) {
                if (!((String)paramString).equals("?")) {
                    paramString = (String)paramString + "&";
                }
                paramString = (String)paramString + theKey + "=" + theValue;
            }
        }
        return paramString;
    }
}

