/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.XmlFileLicense;
import java.io.File;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(service={ArtifactInstaller.class, ArtifactListener.class})
public class LicenseDeployer
implements ArtifactInstaller {
    private static final Logger LOGGER = LogManager.getLogger(LicenseDeployer.class);

    public void install(File file) throws Exception {
        LOGGER.info("install file={}", (Object)file);
        this.loadLicense(file);
    }

    public void update(File file) throws Exception {
        LOGGER.info("update file={}", (Object)file);
        this.loadLicense(file);
    }

    public void uninstall(File file) throws Exception {
        LOGGER.info("uninstall file={} (ignored at the moment, the already loaded license is still in use)", (Object)file);
    }

    public boolean canHandle(File file) {
        LOGGER.debug("canHandle file={}", (Object)file);
        return XmlFileLicense.isWellKnownLicenseFilename(file.getName());
    }

    private void loadLicense(File file) {
        LOGGER.info("loadLicense file={}", (Object)file);
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try (BpcServicesTracker<LicenseService> licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);){
            licenseServiceTracker.getService().loadAndSetLicense(file);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to read/set the BPC license '" + String.valueOf(file) + "'.", (Throwable)ex);
        }
    }
}

