/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.License;
import de.virtimo.bpc.core.license.LicenseKey;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.NoLicense;
import de.virtimo.bpc.core.license.XmlFileLicense;
import de.virtimo.bpc.core.notification.ExpirationNotificationSettings;
import de.virtimo.bpc.core.utils.FelixFileinstallUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.license.Validator;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class LicenseServiceImpl
implements LicenseService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(LicenseServiceImpl.class);
    public static final Integer DEFAULT_APPLICATION_LIMIT = 0;
    public static final Integer DEFAULT_CONCURRENT_USER_LIMIT = 5;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final EventRegistration eventRegistration;
    private License license;

    public LicenseServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.license = new NoLicense();
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEventHandler());
        this.loadAndSetLicenseFromKarafDeployFolder();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public boolean isLicenseSet() {
        return this.license != null && !(this.license instanceof NoLicense);
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    private void loadAndSetLicenseFromKarafDeployFolder() {
        LOGGER.info("loadAndSetLicenseFromKarafDeployFolder");
        File licenseFile = this.getLicenseFileFromKarafDeployFolder();
        if (licenseFile != null) {
            this.loadAndSetLicense(licenseFile);
        }
    }

    private File getLicenseFileFromKarafDeployFolder() {
        LOGGER.info("getLicenseFileFromKarafDeployFolder");
        try {
            File deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
            File licenseFile = new File(deployFolder, "license.xml.bpc");
            if (licenseFile.exists()) {
                return licenseFile;
            }
            licenseFile = new File(deployFolder, "license.xml.virtimo");
            if (licenseFile.exists()) {
                return licenseFile;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the BPC license file from the Karaf deploy folder.", (Throwable)ex);
        }
        return null;
    }

    @Override
    public void setLicense(License license) throws LicenseException {
        LOGGER.info("setLicense license={}", (Object)license);
        if (license == null) {
            license = new NoLicense();
        }
        if (license.isExpired()) {
            throw new LicenseException((ErrorCode)CoreErrorCode.LICENSE_EXPIRED, "License expired on ${expirationDate}", MapUtil.mapOf("expirationDate", license.getValue(LicenseKey.LICENSE_EXPIRATION_DATE)));
        }
        this.license = license;
        this.sendLicenseChangedEvent(license);
    }

    private void sendLicenseChangedEvent(License license) {
        LOGGER.info("sendLicenseChangedEvent license=...");
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/licenseChanged", "license", license);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("Failed to get the event manager service to send the license changed event.", (Throwable)ex);
        }
    }

    @Override
    public void loadAndSetLicense(File licenseFile) {
        LOGGER.info("loadAndSetLicense licenseFile={}", (Object)licenseFile);
        Objects.requireNonNull(licenseFile, "License file cannot be null");
        try {
            URL publicKeyResourcesURL = this.bundleContext.getBundle().getResource("defaults/core/public.key");
            Validator validator = new Validator(publicKeyResourcesURL);
            if (validator.isValid(licenseFile)) {
                XmlFileLicense license = new XmlFileLicense(licenseFile);
                this.setLicense(license);
            } else {
                LOGGER.error("The BPC license '" + licenseFile.getName() + "' loaded from the Karaf deploy folder is invalid.");
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("The BPC license '" + licenseFile.getName() + "' is missing in the Karaf deploy folder.");
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to load the BPC license '" + licenseFile.getName() + "' from the Karaf deploy folder.", ex);
        }
    }

    @Override
    public boolean isModuleWithInstanceLimit(InstantiableModule instantiableModule) {
        LOGGER.info("isModuleWithInstanceLimit instantiableModule=" + String.valueOf(instantiableModule));
        return this.getInstanceLimit(instantiableModule) != null;
    }

    @Override
    public Integer getInstanceLimit(InstantiableModule instantiableModule) {
        Map moduleInstanceLimitMap;
        LOGGER.info("getInstanceLimit instantiableModule={}", (Object)instantiableModule);
        if (instantiableModule != null && (moduleInstanceLimitMap = (Map)this.getLicense().getValue(LicenseKey.MODULE_INSTANCE_LIMIT)) != null && moduleInstanceLimitMap.containsKey(instantiableModule.getModuleId())) {
            int currentLimit = 0;
            Object limitValue = moduleInstanceLimitMap.get(instantiableModule.getModuleId());
            if (limitValue instanceof Integer) {
                currentLimit = (Integer)limitValue;
            } else if (limitValue instanceof String) {
                currentLimit = Integer.parseInt((String)limitValue);
            }
            return currentLimit <= 0 ? null : Integer.valueOf(currentLimit);
        }
        return null;
    }

    @Override
    public Integer getConcurrentUserLimit() {
        LOGGER.info("getConcurrentUserLimit");
        try {
            Object concurrentUserLimitObject = this.getLicense().getValue(LicenseKey.CONCURRENT_USER_LIMIT);
            if (concurrentUserLimitObject instanceof Number) {
                return ((Number)concurrentUserLimitObject).intValue();
            }
            if (concurrentUserLimitObject instanceof String) {
                return Integer.parseInt((String)concurrentUserLimitObject);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the concurrent user limit from the license.", (Throwable)ex);
        }
        return DEFAULT_CONCURRENT_USER_LIMIT;
    }

    @Override
    public boolean isOutdatedLicense() {
        return this.getLicense().getValue(LicenseKey.MODULE_ALLOW_LIST) == null;
    }

    @Override
    public boolean isAllowedModule(InstantiableModule instantiableModule) {
        LOGGER.info("isAllowedModule instantiableModule={}", (Object)instantiableModule);
        if (instantiableModule != null) {
            List allowedModulesList = (List)this.getLicense().getValue(LicenseKey.MODULE_ALLOW_LIST);
            return allowedModulesList != null && allowedModulesList.contains(instantiableModule.getModuleId());
        }
        return false;
    }

    @Override
    public ExpirationNotificationSettings getLicenseExpirationNotificationSettings() throws ServiceNotFoundException, ModuleNotFoundException {
        LOGGER.info("getLicenseExpirationNotificationSettings");
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);){
            CoreModule coreModule = (CoreModule)moduleManagerTracker.getService().getModuleById("_core");
            ExpirationNotificationSettings expirationNotificationSettings = ExpirationNotificationSettings.of(coreModule.getConfiguration().getSetting("licenseNotifications"));
            return expirationNotificationSettings;
        }
    }

    @Override
    public Map<String, Object> getLicenseDetails() {
        LOGGER.info("getLicenseDetails");
        return this.getLicenseDetails(this.license);
    }

    @Override
    public Map<String, Object> getLicenseDetails(License license) {
        LOGGER.info("getLicenseDetails license=...");
        HashMap<String, Object> licenceApplicationKeyMap = new HashMap<String, Object>();
        HashMap<String, Object> licenceModuleKeyMap = new HashMap<String, Object>();
        HashMap<String, Object> licenceOtherKeyMap = new HashMap<String, Object>();
        for (String lk : license.getLicenseKeys()) {
            if (lk.startsWith("APPLICATION_")) {
                licenceApplicationKeyMap.put(lk, license.getValue(lk));
                continue;
            }
            if (lk.startsWith("MODULE_")) {
                licenceModuleKeyMap.put(lk, license.getValue(lk));
                continue;
            }
            licenceOtherKeyMap.put(lk, license.getValue(lk));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("application", licenceApplicationKeyMap);
        result.put("module", licenceModuleKeyMap);
        result.put("other", licenceOtherKeyMap);
        return result;
    }

    @Override
    public Set<String> getNonWriteableSettings() {
        LOGGER.info("getNonWriteableSettings");
        List nonWriteableSettingsList = (List)this.getLicense().getValue(LicenseKey.NON_WRITEABLE_SETTINGS);
        return nonWriteableSettingsList == null ? null : new HashSet(nonWriteableSettingsList);
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            if (LicenseServiceImpl.this.isLicenseSet()) {
                LicenseServiceImpl.this.sendLicenseChangedEvent(LicenseServiceImpl.this.license);
            } else {
                LicenseServiceImpl.this.loadAndSetLicenseFromKarafDeployFolder();
            }
        }
    }
}

