/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.multipart;

import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.util.FilenameUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

public class UploadedFileImpl
implements UploadedFile {
    protected final String attachmentName;
    protected final String fileName;
    protected final MediaType contentType;
    protected File temporaryContentFile;
    private static long uploadCounter = 0L;

    public UploadedFileImpl(UploadedFile otherUploadedFile) throws IOException {
        this.attachmentName = otherUploadedFile.getAttachmentName();
        this.fileName = otherUploadedFile.getFileName();
        this.contentType = otherUploadedFile.getContentType();
        this.temporaryContentFile = otherUploadedFile.getTemporaryContentFile();
    }

    public UploadedFileImpl(Attachment attachment) throws IOException {
        this.attachmentName = this.extractAttachmentNameFromAttachment(attachment);
        this.fileName = this.extractFilenameFromAttachment(attachment);
        this.contentType = this.extractContentTypeFromAttachment(attachment);
        this.temporaryContentFile = this.writeContentFromAttachmentToTemporaryFile(attachment);
    }

    private String extractAttachmentNameFromAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        return attachment.getContentDisposition().getParameter("name");
    }

    private String extractFilenameFromAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        return FilenameUtil.sanitizeFilename(attachment.getContentDisposition().getParameter("filename"));
    }

    private MediaType extractContentTypeFromAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        return attachment.getContentType();
    }

    private File writeContentFromAttachmentToTemporaryFile(Attachment attachment) throws IOException {
        File tmpFile = File.createTempFile("uploaded-bpc-file-" + ++uploadCounter + "-" + System.currentTimeMillis(), ".tmp");
        tmpFile.deleteOnExit();
        Files.copy(attachment.getDataHandler().getInputStream(), tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tmpFile;
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getFileExtension() {
        return FilenameUtil.extractFileExtension(this.fileName);
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public File getTemporaryContentFile() {
        return this.temporaryContentFile;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.temporaryContentFile);
    }

    @Override
    public void cleanUp() {
        if (this.temporaryContentFile != null) {
            this.temporaryContentFile.delete();
            this.temporaryContentFile = null;
        }
    }

    public String toString() {
        return "UploadedFileImpl{attachmentName='" + this.attachmentName + "', fileName='" + this.fileName + "', contentType=" + String.valueOf(this.contentType) + ", temporaryContentFile=" + String.valueOf(this.temporaryContentFile) + "}";
    }
}

