/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.core.notification.ExpirationNotificationSettings;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpirationNotificationEvaluator {
    private static final Logger LOGGER = LogManager.getLogger(ExpirationNotificationEvaluator.class);
    private final LocalDate expirationDate;
    private final ExpirationNotificationSettings expirationNotificationSettings;
    private LocalDate currentDate;
    private String currentTime;
    private boolean timeToNotify;
    private long expiresInDays;
    private Period expiresInPeriod;

    public ExpirationNotificationEvaluator(LocalDate expirationDate, ExpirationNotificationSettings expirationNotificationSettings) {
        this.expirationDate = expirationDate;
        this.expirationNotificationSettings = expirationNotificationSettings;
        this.updateForNow();
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public String getSendNotificationsAtTime() {
        return this.expirationNotificationSettings.getSendAtTime();
    }

    public List<Integer> getSendNotificationsDaysBeforeExpiration() {
        return this.expirationNotificationSettings.getSendDaysBeforeExpiration();
    }

    public LocalDate getCurrentDate() {
        return this.currentDate;
    }

    public String getCurrentTime() {
        return this.currentTime;
    }

    public boolean isTimeToNotify() {
        return this.timeToNotify;
    }

    public long getExpiresInDays() {
        return this.expiresInDays;
    }

    public Period getExpiresInPeriod() {
        return this.expiresInPeriod;
    }

    public void updateForNow() {
        this.currentDate = LocalDate.now();
        this.currentTime = new SimpleDateFormat("HH:mm").format(Calendar.getInstance().getTime());
        List<Integer> sendNotificationsDaysBeforeExpiration = this.expirationNotificationSettings.getSendDaysBeforeExpiration();
        String sendNotificationsAtTime = this.expirationNotificationSettings.getSendAtTime();
        this.expiresInDays = ChronoUnit.DAYS.between(this.currentDate, this.expirationDate);
        this.expiresInPeriod = Period.between(this.currentDate, this.expirationDate);
        LOGGER.info("[{} {}]: Expires on {} ({} years, {} months and {} days)", (Object)this.currentDate, (Object)this.currentTime, (Object)this.expirationDate, (Object)this.expiresInPeriod.getYears(), (Object)this.expiresInPeriod.getMonths(), (Object)this.expiresInPeriod.getDays());
        this.timeToNotify = sendNotificationsDaysBeforeExpiration.contains(Long.valueOf(this.expiresInDays).intValue()) && sendNotificationsAtTime.equals(this.currentTime);
    }
}

