/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.BpcIndexStateException;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.SettingFactory;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.PasswordEncryptorService;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

public class ModuleConfigurationPersistenceHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModuleConfigurationPersistenceHandler.class);
    private final OpenSearchService oss;
    private final PasswordEncryptorService passwordEncryptorService;
    private static final Object PREPARE_BPC_CONFIGURATION_INDEX_LOCK = new Object();

    public ModuleConfigurationPersistenceHandler(OpenSearchService oss, PasswordEncryptorService passwordEncryptorService) {
        this.oss = oss;
        this.passwordEncryptorService = passwordEncryptorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareIndex() throws BpcIndexStateException, OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
        LOGGER.debug("prepareIndex");
        Object object = PREPARE_BPC_CONFIGURATION_INDEX_LOCK;
        synchronized (object) {
            BpcIndexState bpcConfigurationIndexState = this.oss.getIndexState("bpc-configuration");
            bpcConfigurationIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.getManagedIndicesHandler().createManagedIndex("bpc-configuration");
                }
            });
        }
    }

    public static boolean settingsAreDifferent(Setting previousSetting, Setting currentSetting) throws SettingException {
        byte[] previousSettingBytes = previousSetting == null ? null : previousSetting.toJsonAsBytes();
        byte[] currentSettingBytes = currentSetting.toJsonAsBytes();
        return previousSettingBytes == null || !Arrays.equals(previousSettingBytes, currentSettingBytes);
    }

    private Set<String> getSettingIDs(Collection<Setting> settings) {
        HashSet<String> result = new HashSet<String>();
        if (settings != null && !settings.isEmpty()) {
            for (Setting setting : settings) {
                if (setting.getId() == null) continue;
                result.add(setting.getId());
            }
        }
        return result;
    }

    private boolean isPasswordSetting(Setting setting) {
        return setting != null && "password".equalsIgnoreCase(setting.getType());
    }

    private Setting preparedSettingForSave(Setting settingToSave) {
        LOGGER.debug("preparedSettingForSave settingToSave=...");
        if (this.isPasswordSetting(settingToSave)) {
            String encryptedPassword = this.passwordEncryptorService.encrypt((String)settingToSave.getValue());
            SimpleSettingImpl passwordEncryptedSetting = new SimpleSettingImpl(settingToSave);
            passwordEncryptedSetting.setValue(encryptedPassword);
            return passwordEncryptedSetting;
        }
        return settingToSave;
    }

    private Setting preparedSettingAfterLoad(Setting loadedSetting) {
        LOGGER.debug("preparedSettingAfterLoad loadedSetting=...");
        if (this.isPasswordSetting(loadedSetting)) {
            String decryptedPassword = this.passwordEncryptorService.decrypt((String)loadedSetting.getValue());
            SimpleSettingImpl passwordDecryptedSetting = new SimpleSettingImpl(loadedSetting);
            passwordDecryptedSetting.setValue(decryptedPassword);
            return passwordDecryptedSetting;
        }
        return loadedSetting;
    }

    public boolean saveSetting(Setting setting) throws SettingException {
        LOGGER.info("saveSetting setting:{}", (Object)setting);
        if (setting == null || setting.getId() == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save module setting. At least one mandatory field of the setting is not set: ${setting}", MapUtil.mapOf("setting", String.valueOf(setting)));
        }
        long saveSettingTime = System.currentTimeMillis();
        try {
            this.prepareIndex();
            Setting previousSetting = this.readModuleSetting(setting.getId());
            if (previousSetting == null || ModuleConfigurationPersistenceHandler.settingsAreDifferent(previousSetting, setting)) {
                LOGGER.debug("{}: new/modified and gets saved", (Object)setting.getId());
                Setting settingToSave = this.preparedSettingForSave(setting);
                this.oss.index(((IndexRequest)new IndexRequest().index("bpc-configuration")).id(settingToSave.getId()).source(settingToSave.toJsonAsBytes(), (MediaType)XContentType.JSON), RequestOptions.DEFAULT);
                boolean bl = true;
                return bl;
            }
            LOGGER.debug("{}: not modified and must not be saved!", (Object)setting.getId());
            boolean bl = false;
            return bl;
        }
        catch (OpenSearchRelatedException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the setting with the ID '${settingId}' due to an OpenSearch error: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the setting with the ID '${settingId}'.", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
        finally {
            LOGGER.info("{}: saveSetting done in {} ms", (Object)setting.getId(), (Object)(System.currentTimeMillis() - saveSettingTime));
        }
    }

    protected void saveSettings(Collection<Setting> settings) throws SettingException {
        LOGGER.info("saveSettings settings=...");
        if (settings == null || settings.isEmpty()) {
            return;
        }
        for (Setting setting : settings) {
            if (setting != null && setting.getId() != null) continue;
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save settings. At least one mandatory field of a setting is not set: ${setting}", MapUtil.mapOf("setting", String.valueOf(setting)));
        }
        long saveSettingsTime = System.currentTimeMillis();
        try {
            BulkResponse bulkResponse;
            this.prepareIndex();
            Map<String, Setting> previousSettings = this.readModuleSettings(this.getSettingIDs(settings));
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Setting setting : settings) {
                try {
                    Setting previousSetting = previousSettings.get(setting.getId());
                    if (previousSetting == null || ModuleConfigurationPersistenceHandler.settingsAreDifferent(previousSetting, setting)) {
                        LOGGER.debug("{}: modified and gets prepared for save", (Object)setting.getId());
                        Setting settingToSave = this.preparedSettingForSave(setting);
                        bulkRequest.add(((IndexRequest)new IndexRequest().index("bpc-configuration")).id(settingToSave.getId()).source(settingToSave.toJsonAsBytes(), (MediaType)XContentType.JSON));
                        continue;
                    }
                    LOGGER.debug("{}: not modified and must not be saved!", (Object)setting.getId());
                }
                catch (SettingException e) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "The setting with the ID '${settingId}' could not be saved.", MapUtil.mapOf("settingId", setting.getId(), "error", e.getLocalizedMessage()), (Throwable)e);
                }
            }
            if (bulkRequest.numberOfActions() > 0 && (bulkResponse = this.oss.bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to bulk save the module configuration settings: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
        }
        catch (OpenSearchRelatedException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the module configuration settings due to an OpenSearch error: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_SAVE_FAILED, "Failed to save the module configuration settings: ${error}", MapUtil.mapOf("error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        finally {
            LOGGER.debug("saveConfiguration time: {} ms", (Object)(System.currentTimeMillis() - saveSettingsTime));
        }
    }

    private Map<String, Setting> readModuleSettings(Set<String> settingIDs) throws SettingException, OpenSearchRelatedException {
        LOGGER.debug("readModuleSettings settingIDs=...");
        HashMap<String, Setting> result = new HashMap<String, Setting>();
        if (settingIDs != null && !settingIDs.isEmpty()) {
            MultiGetRequest multiGetReq = new MultiGetRequest();
            for (String settingID : settingIDs) {
                multiGetReq.add("bpc-configuration", settingID);
            }
            MultiGetResponse multiGetItemResponses = this.oss.mget(multiGetReq, RequestOptions.DEFAULT);
            for (MultiGetItemResponse itemResponse : multiGetItemResponses) {
                byte[] settingBytes;
                GetResponse response;
                if (itemResponse.isFailed() || (response = itemResponse.getResponse()) == null || !response.isExists() || (settingBytes = response.getSourceAsBytes()) == null) continue;
                String settingId = response.getId();
                Setting s = SettingFactory.parseJsonSetting(settingBytes);
                result.put(settingId, this.preparedSettingAfterLoad(s));
            }
        }
        return result;
    }

    public static Setting readModuleSetting(OpenSearchService oss, String moduleId, String instanceId, String settingName) throws SettingException, OpenSearchRelatedException {
        LOGGER.debug("readModuleSetting oss=..., moduleId={}, instanceId={}, settingName={}", (Object)moduleId, (Object)instanceId, (Object)settingName);
        String settingId = SimpleSettingImpl.createId(moduleId, instanceId, settingName);
        return ModuleConfigurationPersistenceHandler.readModuleSetting(oss, settingId);
    }

    private static Setting readModuleSetting(OpenSearchService oss, String settingId) throws SettingException, OpenSearchRelatedException {
        LOGGER.debug("readModuleSetting oss=..., settingId={}", (Object)settingId);
        try {
            byte[] settingBytes;
            GetRequest getReq = ((GetRequest)new GetRequest().index("bpc-configuration")).id(settingId);
            GetResponse response = oss.get(getReq, RequestOptions.DEFAULT);
            if (response.isExists() && (settingBytes = response.getSourceAsBytes()) != null) {
                return SettingFactory.parseJsonSetting(settingBytes);
            }
        }
        catch (OpenSearchIndexNotFoundException ex) {
            return null;
        }
        return null;
    }

    private Setting readModuleSetting(String settingId) throws SettingException, OpenSearchRelatedException {
        LOGGER.debug("readModuleSetting settingId={}", (Object)settingId);
        try {
            byte[] settingBytes;
            GetRequest getReq = ((GetRequest)new GetRequest().index("bpc-configuration")).id(settingId);
            GetResponse response = this.oss.get(getReq, RequestOptions.DEFAULT);
            if (response.isExists() && (settingBytes = response.getSourceAsBytes()) != null) {
                Setting s = SettingFactory.parseJsonSetting(settingBytes);
                return this.preparedSettingAfterLoad(s);
            }
        }
        catch (OpenSearchIndexNotFoundException ex) {
            return null;
        }
        return null;
    }

    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId) throws SettingException {
        LOGGER.info("readModuleSettings moduleId={}, instanceId={}", (Object)moduleId, (Object)instanceId);
        return this.readModuleSettings(moduleId, instanceId, null);
    }

    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId, String instanceType) throws SettingException {
        LOGGER.info("readModuleSettings moduleId={}, instanceId={}, instanceType={}", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        HashMap<String, Setting> settings = new HashMap<String, Setting>();
        long startTime = System.currentTimeMillis();
        try {
            BoolQueryBuilder qb = instanceType == null ? QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)) : QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)).must(QueryBuilders.termQuery("instanceType", instanceType));
            LOGGER.info("readModuleSettings query: \n" + String.valueOf(qb));
            SearchRequest searchReq = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(250).query(qb).sort("_doc", SortOrder.ASC));
            LOGGER.info("readModuleSettings search request: {}", (Object)searchReq);
            try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(this.oss, searchReq);){
                while (searchScrollIterator.hasNext()) {
                    SearchHits searchHits = searchScrollIterator.next();
                    for (SearchHit hit : searchHits) {
                        Setting s = SettingFactory.parseJsonSetting(hit.getSourceRef().toBytesRef().bytes);
                        if (s != null && hit.getId().equals(s.getId())) {
                            Setting psal = this.preparedSettingAfterLoad(s);
                            settings.put(psal.getName(), psal);
                            continue;
                        }
                        LOGGER.warn("Skipping the invalid module setting: {}", (Object)s);
                    }
                }
            }
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOGGER.warn("Can't read the '{}' module settings. The OpenSearch index '{}' is missing. Should happen only on first start or when someone deleted that index!", (Object)moduleId, (Object)ex.getIndex());
            } else {
                LOGGER.error("Unhandled exception in ModuleManagerImpl.readModuleSettings(). Please report the occurred RestStatus '" + String.valueOf((Object)ex.status()) + "' to the BPC developers.", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Failed to read module settings. Invalid settings data for moduleId=${moduleId}, instanceId=${instanceId} and instanceType=${instanceType}", MapUtil.mapOf("moduleId", moduleId, "instanceId", instanceId, "instanceType", instanceType), (Throwable)ex);
        }
        finally {
            LOGGER.info("readModuleSettings done in {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        return settings;
    }

    public static Settings readAllSettingsFromBpcConfigurationIndex(OpenSearchService oss, String bpcConfigurationIndexName) throws OpenSearchRelatedException {
        LOGGER.info("readAllSettingsFromBpcConfigurationIndex oss=..., bpcConfigurationIndexName={}", (Object)bpcConfigurationIndexName);
        SearchRequest searchReq = new SearchRequest().indices(bpcConfigurationIndexName).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
        SettingsImpl allSettings = new SettingsImpl();
        try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(oss, searchReq);){
            while (searchScrollIterator.hasNext()) {
                SearchHits searchHits = searchScrollIterator.next();
                for (SearchHit hit : searchHits) {
                    Map<String, Object> sourceValues = hit.getSourceAsMap();
                    Setting setting = SettingFactory.parseMapSetting(sourceValues);
                    allSettings.add(setting);
                }
            }
        }
        return allSettings;
    }

    @NotNull
    public Set<String> readModuleInstanceIDs(String moduleId) throws OpenSearchRelatedException {
        LOGGER.debug("readModuleInstanceIDs moduleId={}", (Object)moduleId);
        return this.readModuleInstanceIDs(moduleId, null);
    }

    @NotNull
    public Set<String> readModuleInstanceIDs(String moduleId, String instanceType) throws OpenSearchRelatedException {
        LOGGER.debug("readModuleInstanceIDs moduleId={}, instanceType={}", (Object)moduleId, (Object)instanceType);
        try {
            HashSet<String> instanceIDs = new HashSet<String>();
            RestHighLevelClient osClient = this.oss.getClient();
            BoolQueryBuilder qb = instanceType == null ? QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).mustNot(QueryBuilders.termQuery("instanceId", "noinstance")) : QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).mustNot(QueryBuilders.termQuery("instanceId", "noinstance")).must(QueryBuilders.termQuery("instanceType", instanceType));
            SearchRequest s = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(0).query(qb).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("instanceIds").field("instanceId")).size(Integer.MAX_VALUE)));
            LOGGER.info("readModuleInstanceIDs search request: {}", (Object)s);
            SearchResponse sr = osClient.search(s, RequestOptions.DEFAULT);
            Terms instances = (Terms)sr.getAggregations().get("instanceIds");
            LOGGER.info("agg instance keys: {}", (Object)instances.getBuckets().toString());
            for (Terms.Bucket bucket : instances.getBuckets()) {
                String key = bucket.getKeyAsString();
                long docCount = bucket.getDocCount();
                instanceIDs.add(key);
                LOGGER.info("key [{}], doc_count [{}]", (Object)key, (Object)docCount);
            }
            return instanceIDs;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public String readInstanceType(String moduleId, String instanceId) throws SettingException, OpenSearchRelatedException {
        LOGGER.info("readInstanceType moduleId={}, instanceId={}", (Object)moduleId, (Object)instanceId);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            SearchRequest s = new SearchRequest().indices("bpc-configuration").source(new SearchSourceBuilder().size(0).query(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId))).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("instanceTypes").field("instanceType")).size(Integer.MAX_VALUE)));
            LOGGER.info("readInstanceType search request: {}", (Object)s);
            SearchResponse sr = osClient.search(s, RequestOptions.DEFAULT);
            Terms instanceTypesTerms = (Terms)sr.getAggregations().get("instanceTypes");
            LOGGER.info("agg instance types: {}", (Object)instanceTypesTerms.getBuckets().toString());
            ArrayList<String> instanceTypes = new ArrayList<String>();
            for (Terms.Bucket bucket : instanceTypesTerms.getBuckets()) {
                String key = bucket.getKeyAsString();
                long docCount = bucket.getDocCount();
                LOGGER.info("Key [{}], doc_count [{}", (Object)key, (Object)docCount);
                instanceTypes.add(key);
            }
            if (instanceTypes.size() > 1) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_INVALID, "Invalid settings data for moduleId=${moduleId} and instanceId=${instanceId}. Only one instance type allowed, but found: ${instanceTypesFound}", MapUtil.mapOf("moduleId", moduleId, "instanceId", instanceId, "instanceTypesFound", String.valueOf(instanceTypes)));
            }
            if (instanceTypes.size() == 1) {
                return (String)instanceTypes.get(0);
            }
            return "none";
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    protected Setting deleteSetting(Setting setting) throws SettingException {
        LOGGER.info("delete setting: {}", (Object)setting);
        if (setting == null || setting.getId() == null) {
            return null;
        }
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index("bpc-configuration")).id(setting.getId());
            DeleteResponse response = osClient.delete(deleteRequest, RequestOptions.DEFAULT);
            if (response.status() == RestStatus.NOT_FOUND) {
                LOGGER.warn("Could not find the setting to delete: {}", (Object)setting);
            }
            return setting;
        }
        catch (IOException | OpenSearchException ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_DELETE_FAILED, "Failed to delete the setting with the id '${settingId}' due to an OpenSearch error: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTINGS_DELETE_FAILED, "Failed to delete the setting with the id '${settingId}' due to: ${error}", MapUtil.mapOf("settingId", setting.getId(), "error", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public void deleteModuleInstance(String moduleId, String instanceId) throws OpenSearchRelatedException {
        LOGGER.info("deleteModuleInstance moduleId={}, instanceId={}", (Object)moduleId, (Object)instanceId);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest("bpc-configuration").setQuery(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("moduleId", moduleId)).must(QueryBuilders.termQuery("instanceId", instanceId)));
            LOGGER.info("deleteModuleInstance delete by query request: {}", (Object)deleteByQueryRequest);
            BulkByScrollResponse dbqrsp = osClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            LOGGER.info("deleteModuleInstance Deleted {} related documents from bpc-configuration", (Object)dbqrsp.getDeleted());
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOGGER.warn("Ignoring deletion of not existing index.");
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }
}

