/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion22To23
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion22To23.class);
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion22To23(OpenSearchService oss) {
        super(oss, 23);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map idpConfig;
        Object idpConfigObject;
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        if ("backendconnection".equals(sourceValues.get("moduleId")) && "identity_provider".equals(sourceValues.get("instanceType")) && "identityProvider_configuration".equals(sourceValues.get("name")) && (idpConfigObject = sourceValues.get("value")) instanceof Map && (idpConfig = (Map)idpConfigObject).containsKey("keycloak")) {
            LOGGER.info("Drop no longer needed keycloak configs from identityProvider_configuration for IdP " + String.valueOf(sourceValues.get("instanceId")));
            HashMap updatedIdpConfig = new HashMap(idpConfig);
            idpConfig.remove("keycloak");
            HashMap<String, Object> updatedSourceValues = new HashMap<String, Object>(sourceValues);
            updatedSourceValues.put("value", updatedIdpConfig);
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(updatedSourceValues, (MediaType)XContentType.JSON));
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if ("monitor".equals(moduleId) && "grid_showHeader".equals(settingName)) {
            LOGGER.info("Drop setting grid_showHeader for monitor {}", sourceValues.get("instanceId"));
            return null;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }
}

