/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion23To24
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion23To24.class);
    private static final boolean testRun = false;

    public BpcConfigurationIndexMigrationFromModelVersion23To24(OpenSearchService oss) {
        super(oss, 24);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        if ("plugin_configuration".equals(settingName)) {
            ArrayList pluginConfiguration = (ArrayList)sourceValues.get("value");
            boolean modified = false;
            for (HashMap generalPluginConfigMap : pluginConfiguration) {
                HashMap pluginConfigurationMap;
                String pluginId = (String)generalPluginConfigMap.get("plugin");
                if (!"bpcAccountMenu".equalsIgnoreCase(pluginId) || (pluginConfigurationMap = (HashMap)generalPluginConfigMap.get("configuration")) == null || !pluginConfigurationMap.containsKey("changeLanguage")) continue;
                modified = true;
                pluginConfigurationMap.put("languageSelector", pluginConfigurationMap.get("changeLanguage"));
                pluginConfigurationMap.remove("changeLanguage");
                LOGGER.info("migrate plugin configuration for module {} changed changeLanguage setting to languageSelector", (Object)moduleId);
            }
            if (modified) {
                sourceValues.put("value", pluginConfiguration);
            }
            return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }
}

