/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion27To28
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion27To28.class);
    private static final String OLD_SETTING_NAME = "filterSessionCookie";
    private static final String NEW_SETTING_NAME = "sendSessionId";
    private static final Set<String> MODULE_IDS = Set.of("flow", "backendconnection");
    private static final Set<String> INSTANCE_TYPES = Set.of("http_proxy", "iguasu", "inubit");

    public BpcConfigurationIndexMigrationFromModelVersion27To28(OpenSearchService oss) {
        super(oss, 28);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        String settingName = (String)sourceValues.get("name");
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceType = (String)sourceValues.get("instanceType");
        String valueType = (String)sourceValues.get("type");
        if (OLD_SETTING_NAME.equals(settingName) && INSTANCE_TYPES.contains(instanceType) && MODULE_IDS.contains(moduleId) && "boolean".equals(valueType)) {
            return this.migrateFilterSessionCookieToSendSessionId(newIndex, sourceValues);
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> migrateFilterSessionCookieToSendSessionId(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        String moduleId = (String)sourceValues.get("moduleId");
        String instanceId = (String)sourceValues.get("instanceId");
        String instanceType = (String)sourceValues.get("instanceType");
        boolean value = (Boolean)sourceValues.get("value");
        String newSettingId = this.createV1SettingId(moduleId, instanceId, NEW_SETTING_NAME);
        Map<String, Object> newSettingMap = this.createV1SettingMap(newSettingId, moduleId, instanceId, instanceType, NEW_SETTING_NAME, "boolean", !value);
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(newSettingId).source(newSettingMap, (MediaType)XContentType.JSON));
    }
}

