/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class PercolatorsChecker
implements Checker {
    private static final Logger LOGGER = LogManager.getLogger(PercolatorsChecker.class);
    private static final String INTERVAL_IN_MINUTES_PROPERTY_NAME = "de.virtimo.bpc.core.percolatorschecker.intervalInMinutes";
    private static final long INTERVAL_IN_MINUTES_PROPERTY_DEFAULT = 60L;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;

    public PercolatorsChecker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void startChecker() {
        LOGGER.info("startChecker");
        if (this.checkerHandle != null) {
            LOGGER.warn("Percolators checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(this.bundleContext, PercolatorsManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        try {
            long checkInterval = this.coreBundleConfigurationTracker.getService().getSystemPropertyValueAsLong(INTERVAL_IN_MINUTES_PROPERTY_NAME, 60L);
            LOGGER.info("Init PercolatorsChecker with interval: every {} minutes", (Object)checkInterval);
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-percolators-checker"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), checkInterval, checkInterval, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start the percolators checker.", (Throwable)ex);
        }
    }

    @Override
    public void stopChecker() {
        LOGGER.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOGGER.info("Running percolators checker cancelled");
            } else {
                LOGGER.warn("Could not cancel the running percolators checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
    }

    private Runnable createCheckerRunnable() {
        LOGGER.info("createCheckerRunnable");
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Check for outdated percolators: START");
                long sessionCheckStartTime = System.currentTimeMillis();
                try {
                    OpenSearchService oss = PercolatorsChecker.this.openSearchServiceTracker.getService();
                    PercolatorsManager percolatorsManager = PercolatorsChecker.this.percolatorsManagerTracker.getService();
                    ModuleManager moduleManager = PercolatorsChecker.this.moduleManagerTracker.getService();
                    ClientSessionManager clientSessionManager = PercolatorsChecker.this.clientSessionManagerTracker.getService();
                    CoreBundleConfiguration coreBundleConfiguration = PercolatorsChecker.this.coreBundleConfigurationTracker.getService();
                    OpenSearchBpcPluginManager openSearchBpcPluginManager = PercolatorsChecker.this.openSearchBpcPluginManagerTracker.getService();
                    CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
                    String thisServerUUID = coreBundleConfiguration.getServerUUID();
                    LOGGER.info("thisServerUUID = {}", (Object)thisServerUUID);
                    Set<String> percolatorRelatedIndexNames = percolatorsManager.getPercolatorRelatedIndexNames();
                    if (!percolatorRelatedIndexNames.isEmpty()) {
                        Set<Percolator> percolators = percolatorsManager.getPercolatorsFromIndices(oss, percolatorRelatedIndexNames);
                        ConnectedServersDTO connectedServers = coreModule.isMasterServer() ? openSearchBpcPluginManager.getConnectedServers() : null;
                        LOGGER.info("connectedServers: {}", (Object)connectedServers);
                        HashSet<Percolator> percolatorsToDelete = new HashSet<Percolator>();
                        for (Percolator percolator : percolators) {
                            if (!percolator.isValid()) {
                                LOGGER.info("DELETE invalid percolator: {}", (Object)percolator);
                                percolatorsToDelete.add(percolator);
                                continue;
                            }
                            if (thisServerUUID.equals(percolator.getServerUUID())) {
                                if (clientSessionManager.existsSession(percolator.getSessionId())) continue;
                                LOGGER.info("DELETE percolator without valid session: {}", (Object)percolator);
                                percolatorsToDelete.add(percolator);
                                continue;
                            }
                            if (connectedServers == null || connectedServers.isConnectedServerUUID(percolator.getServerUUID())) continue;
                            LOGGER.info("DELETE percolator without registered server UUID: {}", (Object)percolator);
                            percolatorsToDelete.add(percolator);
                        }
                        if (!percolatorsToDelete.isEmpty()) {
                            percolatorsManager.deletePercolators(oss, percolatorsToDelete);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to perform the check for outdated percolators.", t);
                }
                finally {
                    LOGGER.info("Check for outdated percolators: STOP ({} ms)", (Object)(System.currentTimeMillis() - sessionCheckStartTime));
                }
            }
        };
    }
}

