/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseProduct {
    private static final Logger LOGGER = LogManager.getLogger(DatabaseProduct.class);

    public static Identifier getIdentifier(Connection connection) {
        if (connection == null) {
            return null;
        }
        try {
            return DatabaseProduct.getIdentifier(connection.getMetaData());
        }
        catch (SQLException ex) {
            LOGGER.warn("Failed to get the database metadata from the provided JDBC connection.", (Throwable)ex);
            return null;
        }
    }

    public static Identifier getIdentifier(DatabaseMetaData databaseMetaData) {
        if (databaseMetaData == null) {
            return null;
        }
        try {
            return DatabaseProduct.getIdentifier(databaseMetaData.getDatabaseProductName());
        }
        catch (SQLException ex) {
            LOGGER.warn("Failed to get the database product name from the provided database metadata.", (Throwable)ex);
            return null;
        }
    }

    public static Identifier getIdentifier(String databaseProductName) {
        if (databaseProductName == null) {
            return null;
        }
        String lowerCaseDatabaseProductName = databaseProductName.toLowerCase();
        if (lowerCaseDatabaseProductName.contains("oracle")) {
            return Identifier.ORACLE;
        }
        if (lowerCaseDatabaseProductName.contains("microsoft")) {
            return Identifier.MSSQL;
        }
        if (lowerCaseDatabaseProductName.contains("mysql")) {
            return Identifier.MYSQL;
        }
        if (lowerCaseDatabaseProductName.contains("postgresql")) {
            return Identifier.POSTGRESQL;
        }
        if (lowerCaseDatabaseProductName.contains("mariadb")) {
            return Identifier.MARIADB;
        }
        if (lowerCaseDatabaseProductName.contains("db2")) {
            return Identifier.DB2;
        }
        LOGGER.warn("Did not recognized the used database. Please let the BPC developer know that you use a database with the product name: '{}' .", (Object)databaseProductName);
        return null;
    }

    public static enum Identifier {
        ORACLE,
        MSSQL,
        MYSQL,
        POSTGRESQL,
        MARIADB,
        DB2;

    }
}

