/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceException;
import de.virtimo.bpc.core.lookupjoins.LookupJoin;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.resource.response.BpcStatusUserImpl;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationJobsConverter {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationJobsConverter.class);
    private final ReplicationModule replicationModule;
    private final Set<String> dataSourcesFromKaraf;

    public ReplicationJobsConverter(ReplicationModule replicationModule, DatabaseManager databaseManager) {
        this.replicationModule = replicationModule;
        this.dataSourcesFromKaraf = this.getDataSourcesFromKaraf(databaseManager);
    }

    private Set<String> getDataSourcesFromKaraf(DatabaseManager databaseManager) {
        try {
            return new HashSet<String>(databaseManager.getAllDataSourceNames());
        }
        catch (DataSourceException ex) {
            LOGGER.error("Failed to get the data sources from Karaf.", (Throwable)ex);
            return null;
        }
    }

    public ReplicationJobRuntimeStatsDTO convertToReplicationJobRuntimeStatsDTO(String fromServerUUID, ReplicationJob job) {
        return new ReplicationJobRuntimeStatsDTO(fromServerUUID, job.getId(), job.getName(), this.createDTOReplication(job), this.createDTOShadowCopy(job), this.createDTOTailSync(job), this.createDTOConsistencyCheck(job), this.createDTOLookupJoins(job));
    }

    private ReplicationJobRuntimeStatsDTO.Replication createDTOReplication(ReplicationJob job) {
        return new ReplicationJobRuntimeStatsDTO.Replication(job.isEnabled(), job.getStats().isRunning(), job.getSettings().getReplicationInterval(), job.getStats().getJobCount(), job.getStats().getErrorCount(), job.getStats().getCurrentErrorMessage(), BpcStatusUserImpl.formattedDate(job.getLastDataRecordTimestamp()), BpcStatusUserImpl.formattedDate(job.getLastUpdateTimestamp()), BpcStatusUserImpl.formattedDate(job.getStats().getLastRunStartDate()), BpcStatusUserImpl.formattedDate(job.getStats().getLastRunEndDate()), BpcStatusUserImpl.formattedDate(job.getLastUpdateTimestampOnRestart()), job.getStats().getReplicatedRecords(), job.getSource().getDataSourceName(), this.dataSourcesFromKaraf != null && this.dataSourcesFromKaraf.contains(job.getSource().getDataSourceName()));
    }

    private ReplicationJobRuntimeStatsDTO.ShadowCopy createDTOShadowCopy(ReplicationJob job) {
        ShadowCopy shadowCopy = job.getShadowCopy();
        return new ReplicationJobRuntimeStatsDTO.ShadowCopy(shadowCopy.isEnabled(), shadowCopy.isRunning(), shadowCopy.getCronPattern(), shadowCopy.getKeepCopiesCount(), BpcStatusUserImpl.formattedDate(shadowCopy.getLastRunStart()), BpcStatusUserImpl.formattedDate(shadowCopy.getLastRunEnd()));
    }

    private ReplicationJobRuntimeStatsDTO.TailSync createDTOTailSync(ReplicationJob job) {
        TailSync tailSync = job.getTailSync();
        return new ReplicationJobRuntimeStatsDTO.TailSync(tailSync.isEnabled(), tailSync.isRunning(), tailSync.getRunCount(), tailSync.getErrorCount(), tailSync.getCronPattern(), tailSync.getRelativeStartDate(), tailSync.getRelativeEndDate(), tailSync.getRelativeDeleteOlderThanDate(), BpcStatusUserImpl.formattedDate(tailSync.getLastRunStart()), BpcStatusUserImpl.formattedDate(tailSync.getLastRunEnd()), tailSync.getNewRecords(), tailSync.getUpdatedRecords(), tailSync.getDeletedRecords());
    }

    private ReplicationJobRuntimeStatsDTO.ConsistencyCheck createDTOConsistencyCheck(ReplicationJob job) {
        ConsistencyCheck consistencyCheck = job.getConsistencyCheck();
        return new ReplicationJobRuntimeStatsDTO.ConsistencyCheck(consistencyCheck.isEnabled(), consistencyCheck.areSourceAndTargetConsistent(), consistencyCheck.getConsistencyCheckFrequency(), consistencyCheck.isRunning(), consistencyCheck.getRunCount(), consistencyCheck.getErrorCount(), BpcStatusUserImpl.formattedDate(consistencyCheck.getLastRunStart()), BpcStatusUserImpl.formattedDate(consistencyCheck.getLastRunEnd()), consistencyCheck.getLastRunSourceDocsCount(), consistencyCheck.getLastRunTargetDocsCount());
    }

    private ReplicationJobRuntimeStatsDTO.LookupJoins createDTOLookupJoins(ReplicationJob job) {
        ReplicationJobRuntimeStatsDTO.LookupJoins result = new ReplicationJobRuntimeStatsDTO.LookupJoins();
        LookupJoins lookupJoins = this.replicationModule.getLookupJoinsOfReplicationJob(job.getId());
        if (lookupJoins.hasEntries()) {
            for (LookupJoin lookupJoinEntry : lookupJoins.getEntries()) {
                result.add(new ReplicationJobRuntimeStatsDTO.LookupJoin(lookupJoinEntry.getKeyField(), lookupJoinEntry.getKeyFieldValuesSeparator(), lookupJoinEntry.getLookupIndex() + "/" + lookupJoinEntry.getLookupKeyField()));
            }
        }
        return result;
    }
}

