/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.core.replicator.DatabaseProduct;
import de.virtimo.bpc.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SourceTableNameExtractor {
    private String separator;
    private String catalogName = null;
    private String schemaName = null;
    private String tableName = null;

    public SourceTableNameExtractor(DatabaseMetaData databaseMetaData, String sourceTableName) throws SQLException {
        if (!StringUtil.isNullOrEmpty(sourceTableName)) {
            DatabaseProduct.Identifier dbIdentifier;
            List<String> sourceTableNameParts;
            this.separator = databaseMetaData.getCatalogSeparator();
            if (StringUtil.isNullOrEmpty(this.separator)) {
                this.separator = ".";
            }
            if ((sourceTableNameParts = SourceTableNameExtractor.splitSourceTableName(dbIdentifier = DatabaseProduct.getIdentifier(databaseMetaData), sourceTableName, this.separator)).size() == 3) {
                this.catalogName = sourceTableNameParts.get(0);
                this.schemaName = sourceTableNameParts.get(1);
                this.tableName = sourceTableNameParts.get(2);
            } else if (sourceTableNameParts.size() == 2) {
                boolean valid = false;
                if (!valid) {
                    ResultSet schemaCheckResultSet = databaseMetaData.getTables(null, sourceTableNameParts.get(0), sourceTableNameParts.get(1), null);
                    if (schemaCheckResultSet.next()) {
                        valid = true;
                        this.schemaName = sourceTableNameParts.get(0);
                        this.tableName = sourceTableNameParts.get(1);
                    }
                    schemaCheckResultSet.close();
                }
                if (!valid) {
                    ResultSet catalogCheckResultSet = databaseMetaData.getTables(sourceTableNameParts.get(0), null, sourceTableNameParts.get(1), null);
                    if (catalogCheckResultSet.next()) {
                        valid = true;
                        this.catalogName = sourceTableNameParts.get(0);
                        this.tableName = sourceTableNameParts.get(1);
                    }
                    catalogCheckResultSet.close();
                }
            } else if (sourceTableNameParts.size() == 1) {
                this.tableName = sourceTableNameParts.get(0);
            }
        }
    }

    private static List<String> splitSourceTableName(DatabaseProduct.Identifier databaseIdentifier, String sourceTableName, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String sourceTableNamePart : StringUtil.explode(sourceTableName, separator)) {
            if (databaseIdentifier == DatabaseProduct.Identifier.MSSQL) {
                result.add(SourceTableNameExtractor.cleanupForMSSQL(sourceTableNamePart));
                continue;
            }
            result.add(sourceTableNamePart);
        }
        return result;
    }

    private static String cleanupForMSSQL(String sourceTableNamePart) {
        if (sourceTableNamePart != null) {
            boolean escapedWithDoubleQuotes;
            boolean escapedWithSquareBrackets = sourceTableNamePart.startsWith("[") && sourceTableNamePart.endsWith("]");
            boolean bl = escapedWithDoubleQuotes = sourceTableNamePart.startsWith("\"") && sourceTableNamePart.endsWith("\"");
            if (escapedWithSquareBrackets || escapedWithDoubleQuotes) {
                return sourceTableNamePart.substring(1, sourceTableNamePart.length() - 1);
            }
        }
        return sourceTableNamePart;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isParsed() {
        return this.catalogName != null || this.schemaName != null || this.tableName != null;
    }

    public String toString() {
        return "SourceTableNameExtractor{separator='" + this.separator + "', catalogName='" + this.catalogName + "', schemaName='" + this.schemaName + "', tableName='" + this.tableName + "'}";
    }
}

