/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.core.replicator.DbQueryBuilder;
import de.virtimo.bpc.util.MapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ConsistencyCheckDatabaseHandler {
    private static final Logger LOGGER = LogManager.getLogger(ConsistencyCheckDatabaseHandler.class);
    private final DataSource dataSource;
    private final String commonTableExpressionQuery;
    private final String tableName;
    private final String lastUpdateColumn;
    private final Calendar lastUpdateColumnTimezoneCalendar;
    private final String loggingPrefix;

    ConsistencyCheckDatabaseHandler(DataSource dataSource, String commonTableExpressionQuery, String tableName, String lastUpdateColumn, Calendar lastUpdateColumnTimezoneCalendar, String loggingPrefix) {
        this.dataSource = dataSource;
        this.commonTableExpressionQuery = commonTableExpressionQuery;
        this.tableName = tableName;
        this.lastUpdateColumn = lastUpdateColumn;
        this.lastUpdateColumnTimezoneCalendar = lastUpdateColumnTimezoneCalendar;
        this.loggingPrefix = loggingPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countRecords(Timestamp lowerDateLimit, Timestamp upperDateLimit) throws SQLException {
        LOGGER.info("{}: countRecords lowerDateLimit:{}, upperDateLimit:{}", (Object)this.loggingPrefix, (Object)lowerDateLimit, (Object)upperDateLimit);
        long start = System.currentTimeMillis();
        try {
            long result = -1L;
            try (Connection connection = this.dataSource.getConnection();){
                String sqlTemplate = new DbQueryBuilder(connection).withCommonTableExpressionQuery(this.tableName, this.commonTableExpressionQuery).withQuery("SELECT count(*) AS COUNT FROM $TABLE WHERE $LASTUPDATE_COLUMN >= ? AND $LASTUPDATE_COLUMN <= ?").withPlaceHolders(MapUtil.mapOf("$TABLE", this.tableName, "$LASTUPDATE_COLUMN", this.lastUpdateColumn)).build();
                try (PreparedStatement countPreparedStatement = connection.prepareStatement(sqlTemplate, 1003, 1007);){
                    if (this.lastUpdateColumnTimezoneCalendar != null) {
                        countPreparedStatement.setTimestamp(1, lowerDateLimit, this.lastUpdateColumnTimezoneCalendar);
                        countPreparedStatement.setTimestamp(2, upperDateLimit, this.lastUpdateColumnTimezoneCalendar);
                    } else {
                        countPreparedStatement.setTimestamp(1, lowerDateLimit);
                        countPreparedStatement.setTimestamp(2, upperDateLimit);
                    }
                    LOGGER.debug("{}: {} (from: {}, to: {})", (Object)this.loggingPrefix, (Object)sqlTemplate, (Object)lowerDateLimit, (Object)upperDateLimit);
                    try (ResultSet rs = countPreparedStatement.executeQuery();){
                        result = rs.next() ? rs.getLong("COUNT") : 0L;
                    }
                }
            }
            long l = result;
            return l;
        }
        finally {
            LOGGER.debug("{}: countRecords time: {} ms", (Object)this.loggingPrefix, (Object)(System.currentTimeMillis() - start));
        }
    }
}

