/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.consistency;

import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckDatabaseHandler;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckOpenSearchHandler;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsistencyCheckTask {
    private static final Logger LOGGER = LogManager.getLogger(ConsistencyCheckTask.class);
    private ReplicationJobSettings replicationJobSettings;
    private DataSource dataSource;
    private OpenSearchService oss;
    private String loggingPrefix;
    private ReplicationSource source;
    private ReplicationTarget target;

    private ConsistencyCheckTask() {
    }

    public ConsistencyCheckTask(String loggingPrefix, ReplicationJobSettings replicationJobSettings, ReplicationSource replicationSource, ReplicationTarget replicationTarget, DataSource dataSource, OpenSearchService oss) {
        this.replicationJobSettings = replicationJobSettings;
        this.dataSource = dataSource;
        this.oss = oss;
        this.loggingPrefix = loggingPrefix;
        this.source = replicationSource;
        this.target = replicationTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistencyCheckResult process() throws DataSourceNotFoundException, SQLException, OpenSearchRelatedException {
        LOGGER.info("{}: process", (Object)this.loggingPrefix);
        long start = System.currentTimeMillis();
        try {
            ConsistencyCheckOpenSearchHandler osHandler = new ConsistencyCheckOpenSearchHandler(this.oss, this.target.getIndex(), this.source.getLastUpdateColumn(), this.target.getDbColumnNamesToOpenSearchFieldNamesConverter(), this.loggingPrefix);
            ConsistencyCheckDatabaseHandler dbHandler = new ConsistencyCheckDatabaseHandler(this.dataSource, this.source.getCommonTableExpressionQuery(), this.source.getTable(), this.source.getLastUpdateColumn(), this.source.getLastUpdateColumnTimeZoneCalendar(), this.loggingPrefix);
            Instant lowerDateLimit = this.replicationJobSettings.getReplicationStartDateAsDate().toInstant();
            LOGGER.info("{}: lower date limit: {}", (Object)this.loggingPrefix, (Object)lowerDateLimit);
            Instant upperDateLimit = osHandler.getUpperTargetDate();
            LOGGER.info("{}: upper date limit: {}", (Object)this.loggingPrefix, (Object)upperDateLimit);
            if (upperDateLimit == null) {
                LOGGER.info("{}: Could not perform the consistency check without an upper date limit from the OpenSearch documents", (Object)this.loggingPrefix);
                ConsistencyCheckResult consistencyCheckResult = new ConsistencyCheckResult(-1L, -1L);
                return consistencyCheckResult;
            }
            long numberOfSourceRows = dbHandler.countRecords(Timestamp.from(lowerDateLimit), Timestamp.from(upperDateLimit));
            LOGGER.info("{}: numberOfSourceRows ......: {}", (Object)this.loggingPrefix, (Object)numberOfSourceRows);
            long numberOfTargetDocuments = osHandler.countDocuments(lowerDateLimit, upperDateLimit);
            LOGGER.info("{}: numberOfTargetDocuments .: {}", (Object)this.loggingPrefix, (Object)numberOfTargetDocuments);
            ConsistencyCheckResult consistencyCheckResult = new ConsistencyCheckResult(numberOfSourceRows, numberOfTargetDocuments);
            return consistencyCheckResult;
        }
        finally {
            LOGGER.debug("{}: process time: {} ms", (Object)this.loggingPrefix, (Object)(System.currentTimeMillis() - start));
        }
    }
}

