/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync.logger;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.AbstractSettingsUpdatedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.tailsync.logger.TailsyncLogData;
import de.virtimo.bpc.core.replicator.tailsync.logger.TailsyncLogService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class TailsyncLogServiceImpl
implements TailsyncLogService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(TailsyncLogServiceImpl.class);
    public static final String INDEX_NAME = "bpc-tailsync-log";
    private static final String TAILSYNC_LOGGING_ENABLED_SETTING_NAME = "replicationJobsTailsyncLogEnabled";
    private static final String CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME = "replicationJobsTailsyncLogCleanupPeriodInMinutes";
    private static final String DELETE_ENTRIES_OLDER_THAN_SETTING_NAME = "replicationJobsTailsyncLogDeleteEntriesOlderThan";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final EventRegistration eventRegistration;
    private ReplicationModule replicationModule;
    private boolean isEnabled = false;

    public TailsyncLogServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.isEnabled = false;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("replication", new ReplicationModuleLoadedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("replication", TAILSYNC_LOGGING_ENABLED_SETTING_NAME, new EnabledSettingUpdatedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("replication", new IndexCleanupSettingsUpdatedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        this.stopTailsyncLogIndexCleanupTask();
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
        this.replicationModule = null;
    }

    @Override
    public void log(TailsyncLogData tailsyncLogData) throws Exception {
        LOGGER.debug("log tailsyncLogData=...");
        if (!this.isEnabled) {
            LOGGER.debug("log - skip because tailsync logging is not active");
            return;
        }
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            Map<String, Object> logEntryMap = this.convertLogDataToMap(oss, tailsyncLogData);
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(INDEX_NAME)).source(logEntryMap, (MediaType)XContentType.JSON);
            IndexResponse indexResponse = oss.index(indexRequest, RequestOptions.DEFAULT);
            this.percolatorsManagerTracker.getService().informClientsAboutSingleIndexData(oss, INDEX_NAME, indexResponse);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.error("OpenSearch service is not registered.", (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to write the replication job logs in batch.", (Throwable)ex);
        }
    }

    private Map<String, Object> convertLogDataToMap(OpenSearchService oss, TailsyncLogData logData) throws ServiceNotFoundException {
        HashMap<String, Object> logEntry = new HashMap<String, Object>();
        logEntry.put("replicationJobId", logData.replicationJobId());
        logEntry.put("dataSource", logData.dataSource());
        logEntry.put("sourceTable", logData.sourceTable());
        logEntry.put("targetIndex", logData.targetIndex());
        logEntry.put("deleteEntriesOlderThan", logData.deleteEntriesOlderThan());
        logEntry.put("usedBlockDayRange", logData.usedBlockDayRange());
        logEntry.put("usedBlockSize", logData.usedBlockSize());
        logEntry.put("relativeStartDate", logData.relativeStartDate());
        logEntry.put("relativeEndDate", logData.relativeEndDate());
        logEntry.put("startDate", oss.formatForOpenSearch(logData.startDate()));
        logEntry.put("endDate", oss.formatForOpenSearch(logData.endDate()));
        logEntry.put("durationInMilliseconds", logData.durationInMilliseconds());
        logEntry.put("manualStart", logData.manualStart());
        logEntry.put("addedEntries", logData.addedEntries());
        logEntry.put("updatedEntries", logData.updatedEntries());
        logEntry.put("deletedEntries", logData.deletedEntries());
        logEntry.put("error", logData.error());
        logEntry.put("warnings", logData.warnings());
        return logEntry;
    }

    private void stopTailsyncLogIndexCleanupTask() {
        LOGGER.info("stopTailsyncLogIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop/cancel the running cleanup task for the index 'bpc-tailsync-log'.", (Throwable)ex);
        }
    }

    private boolean canStartCleanupTask() {
        LOGGER.debug("canStartCleanupTask");
        if (this.replicationModule == null) {
            return false;
        }
        return this.replicationModule.getConfiguration().getSettingValue(TAILSYNC_LOGGING_ENABLED_SETTING_NAME).asBoolean(false);
    }

    private void restartTailsyncLogIndexCleanupTask() {
        LOGGER.info("restartTailsyncLogIndexCleanupTask");
        this.stopTailsyncLogIndexCleanupTask();
        if (this.canStartCleanupTask()) {
            try {
                int cleanupPeriodInMinutes = this.replicationModule.getConfiguration().getSettingValue(CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME).asInt(60);
                String deleteEntriesOlderThanSettingValue = this.replicationModule.getConfiguration().getSettingValue(DELETE_ENTRIES_OLDER_THAN_SETTING_NAME).asString("4 weeks ago");
                this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "endDate", deleteEntriesOlderThanSettingValue, cleanupPeriodInMinutes, TimeUnit.MINUTES);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to schedule the index cleanup task for the index 'bpc-tailsync-log'.", (Throwable)ex);
            }
        }
    }

    private class ReplicationModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private ReplicationModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            TailsyncLogServiceImpl.this.replicationModule = (ReplicationModule)module;
            TailsyncLogServiceImpl.this.isEnabled = TailsyncLogServiceImpl.this.replicationModule.getConfiguration().getSettingValue(TailsyncLogServiceImpl.TAILSYNC_LOGGING_ENABLED_SETTING_NAME).asBoolean(false);
            TailsyncLogServiceImpl.this.restartTailsyncLogIndexCleanupTask();
        }
    }

    class EnabledSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        EnabledSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting setting) {
            LOGGER.info("{}.processSetting setting=...", (Object)this.getClass().getSimpleName());
            TailsyncLogServiceImpl.this.restartTailsyncLogIndexCleanupTask();
        }
    }

    class IndexCleanupSettingsUpdatedEventHandler
    extends AbstractSettingsUpdatedEventHandler {
        IndexCleanupSettingsUpdatedEventHandler() {
        }

        @Override
        protected boolean canProcessEvent(Event event) {
            return this.isModuleUpdatedEventOfSettings(event, Arrays.asList(TailsyncLogServiceImpl.CLEANUP_PERIOD_IN_MINUTES_SETTING_NAME, TailsyncLogServiceImpl.DELETE_ENTRIES_OLDER_THAN_SETTING_NAME));
        }

        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            TailsyncLogServiceImpl.this.restartTailsyncLogIndexCleanupTask();
        }
    }
}

