/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.auth.UserSession;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.NewCookie;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BpcCookieCreator {
    private static final Logger LOGGER = LogManager.getLogger(BpcCookieCreator.class);
    private static final String COOKIE_COMMENT = "Virtimo AG - Business Process Center";
    private final String bpcCookieName;
    private final String bpcClientPath;

    public BpcCookieCreator(String bpcCookieName, String bpcClientPath) {
        this.bpcCookieName = bpcCookieName;
        this.bpcClientPath = bpcClientPath;
    }

    public NewCookie createDeleteCookie() {
        LOGGER.debug("createDeleteCookie");
        return new NewCookie(this.bpcCookieName, "deleted", this.bpcClientPath, null, 1, COOKIE_COMMENT, 0, new Date(0L), false, true);
    }

    public NewCookie createSessionCookie(UserSession userSession, boolean secureCookie) {
        LOGGER.debug("createSessionCookie userSession=..., secureCookie={}", (Object)secureCookie);
        String cookieValue = userSession.getSessionId();
        long diff = userSession.getExpirationDate().getTime() - new Date().getTime();
        long seconds = TimeUnit.MILLISECONDS.toSeconds(diff);
        int maxAge = (int)seconds;
        return new NewCookie(this.bpcCookieName, cookieValue, this.bpcClientPath, null, "Virtimo AG - Business Process Center (__SAME_SITE_STRICT__)", maxAge, secureCookie, true);
    }
}

