/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="configuration")
@Tag(name="Configuration File API", description="These are the endpoints to set properties in the BPC related Karaf properties file: `etc/de.virtimo.bpc.core.cfg`")
public class ConfigurationLocalEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationLocalEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<IpPinningService> ipPinningServiceTracker;

    public ConfigurationLocalEndpoint(BundleContext bundleContext) {
        LOGGER.info("ConfigurationLocalEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.ipPinningServiceTracker = new BpcServicesTracker<IpPinningService>(this.bundleContext, IpPinningService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @Produces(value={"application/json"})
    @PUT
    @Path(value="/local/{propertyName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcEndpoint(skipIpPinningCheck=true)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Sets a property in the local BPC related Karaf properties file.", description="Sets a property in the local BPC related Karaf properties file: `etc/de.virtimo.bpc.core.cfg`.\n\nRequired Role and Right:\n\n- Role  : `SERVER_ADMIN`\n- Right : `SERVER_SET_LOCAL_PROPERTY`\n")
    public Response setLocalProperty(@Parameter(description="the name of the property") @PathParam(value="propertyName") String propertyName, @Parameter(description="the value of the property") @QueryParam(value="value") String propertyValue, @Parameter(description="the type of the property") @QueryParam(value="type") String propertyType, @Parameter(description="by default only existing properties can be updated, set to `true` to add new ones") @QueryParam(value="force") String force, @Context HttpHeaders httpHeaders, @Context HttpServletRequest servletRequest) {
        LOGGER.info("setLocalProperty propertyName={}, value={}, type={}, force={}", (Object)propertyName, (Object)propertyValue, (Object)propertyType, (Object)force);
        try {
            ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            IpPinningService ipPinningService = this.ipPinningServiceTracker.getService();
            UserSession userSession = clientSessionManager.getUserSession(servletRequest);
            if (userSession != null && (userSession.hasRole("SERVER_ADMIN") || userSession.hasRight("SERVER_SET_LOCAL_PROPERTY")) && ipPinningService.isValidRequest(servletRequest, userSession) || CoreModule.isRequestFromOtherBpcServer(httpHeaders, coreBundleConfiguration, openSearchBpcPluginManager)) {
                block19: {
                    if ((StringUtil.isNullOrEmpty(force) || Boolean.parseBoolean(force) != Boolean.TRUE) && !coreBundleConfiguration.existsSystemProperty(propertyName)) {
                        throw new SystemException((ErrorCode)CoreErrorCode.LOCAL_SETTING_NOT_FOUND, "Did not find the property '${propertyName}'.", MapUtil.mapOf("propertyName", propertyName));
                    }
                    if ("de.virtimo.bpc.core.maintenancemode".equals(propertyName)) {
                        CoreModule coreModule = this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
                        if (coreModule.isMaintenanceModeUpdateAlreadyRunning()) {
                            throw new SystemException((ErrorCode)CoreErrorCode.LOCAL_SETTING_UPDATE_ALREADY_IN_PROGRESS, "Cannot update the property '${propertyName}' concurrently.", MapUtil.mapOf("propertyName", propertyName));
                        }
                        if (CoreModule.isRequestFromOtherBpcServer(httpHeaders, coreBundleConfiguration, openSearchBpcPluginManager)) {
                            if (Boolean.valueOf(propertyValue) == Boolean.TRUE) {
                                SystemAuditLog.info("MaintenanceModeEnabled", "Requested from other BPC server (Active/Active)");
                            } else {
                                SystemAuditLog.info("MaintenanceModeDisabled", "Requested from other BPC server (Active/Active)");
                            }
                        } else if (Boolean.valueOf(propertyValue) == Boolean.TRUE) {
                            UserAuditLog.info(userSession, "MaintenanceModeEnabled", "Requested by using the configuration endpoint (e.g. BPC Frontend)");
                        } else {
                            UserAuditLog.info(userSession, "MaintenanceModeDisabled", "Requested by using the configuration endpoint (e.g. BPC Frontend)");
                        }
                    }
                    try {
                        if (StringUtil.isNullOrEmpty(propertyType) || "string".equalsIgnoreCase(propertyType)) {
                            coreBundleConfiguration.setSystemPropertyValue(propertyName, propertyValue);
                            break block19;
                        }
                        if (SetUtil.setOf("bool", "boolean").contains(propertyType.toLowerCase())) {
                            coreBundleConfiguration.setSystemPropertyValue(propertyName, Boolean.parseBoolean(propertyValue));
                            break block19;
                        }
                        if (SetUtil.setOf("int", "integer").contains(propertyType.toLowerCase())) {
                            coreBundleConfiguration.setSystemPropertyValue(propertyName, Integer.parseInt(propertyValue));
                            break block19;
                        }
                        if (SetUtil.setOf("long").contains(propertyType.toLowerCase())) {
                            coreBundleConfiguration.setSystemPropertyValue(propertyName, Long.parseLong(propertyValue));
                            break block19;
                        }
                        if (SetUtil.setOf("float").contains(propertyType.toLowerCase())) {
                            coreBundleConfiguration.setSystemPropertyValue(propertyName, Float.valueOf(Float.parseFloat(propertyValue)));
                            break block19;
                        }
                        throw new SystemException((ErrorCode)CoreErrorCode.LOCAL_SETTING_INVALID_INPUT, "Unknown property type '${propertyType}' given", MapUtil.mapOf("propertyType", propertyType));
                    }
                    catch (NumberFormatException ex) {
                        throw new SystemException((ErrorCode)CoreErrorCode.LOCAL_SETTING_INVALID_INPUT, "Cannot use the given value for type '${propertyType}'", MapUtil.mapOf("propertyType", propertyType));
                    }
                }
                return Response.ok().build();
            }
            throw new SystemException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "Not allowed to set local server properties", MapUtil.mapOf("requiredRole", "SERVER_ADMIN", "requiredRight", "SERVER_SET_LOCAL_PROPERTY"));
        }
        catch (Exception ex) {
            LOGGER.error("Could not set the local property value.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Produces(value={"application/json"})
    @PUT
    @Path(value="/server/{serverUUID}/{propertyName}")
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="SERVER_ADMIN", right="SERVER_SET_REMOTE_PROPERTY", message="Not allowed to set remote server properties")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Sets a property in the remote BPC related Karaf properties file.", description="Sets a property in the remote BPC related Karaf properties file: `etc/de.virtimo.bpc.core.cfg`.")
    @ReturnDescription(value="The response of the remote BPC.")
    public Response setRemoteProperty(@Parameter(description="the UUID of the remote BPC server") @PathParam(value="serverUUID") String serverUUID, @Parameter(description="the name of the property") @PathParam(value="propertyName") String propertyName, @Parameter(description="the value of the property") @QueryParam(value="value") String propertyValue, @Parameter(description="the type of the property") @QueryParam(value="type") String propertyType, @Parameter(description="by default only existing properties can be updated, set to `true` to add new ones") @QueryParam(value="force") String force, @Context UriInfo uriInfo, @Context HttpHeaders hh) {
        Response response;
        block12: {
            LOGGER.info("setRemoteProperty serverUUID={}, propertyName={}, value={}, type={}, force={}", (Object)serverUUID, (Object)propertyName, (Object)propertyValue, (Object)propertyType, (Object)force);
            Client client = null;
            try {
                client = RestWebServiceClientFactory.newClient(false);
                ConnectedServerDTO connectedServer = this.openSearchBpcPluginManagerTracker.getService().getConnectedServers().getConnectedServerByUUID(serverUUID);
                String remoteServerUrl = uriInfo.getRequestUri().getScheme() + "://" + connectedServer.getServerStateInfo().getServerAddress() + ":" + connectedServer.getServerStateInfo().getServerHttpPort() + "/cxf/bpc-core/configuration/local";
                remoteServerUrl = remoteServerUrl + "/" + URLEncoder.encode(propertyName, StandardCharsets.UTF_8);
                remoteServerUrl = remoteServerUrl + "?";
                if (propertyValue != null) {
                    if (!remoteServerUrl.endsWith("?")) {
                        remoteServerUrl = remoteServerUrl + "&";
                    }
                    remoteServerUrl = remoteServerUrl + "value=" + URLEncoder.encode(propertyValue, StandardCharsets.UTF_8);
                }
                if (propertyType != null) {
                    if (!remoteServerUrl.endsWith("?")) {
                        remoteServerUrl = remoteServerUrl + "&";
                    }
                    remoteServerUrl = remoteServerUrl + "type=" + URLEncoder.encode(propertyType, StandardCharsets.UTF_8);
                }
                if (force != null) {
                    if (!remoteServerUrl.endsWith("?")) {
                        remoteServerUrl = remoteServerUrl + "&";
                    }
                    remoteServerUrl = remoteServerUrl + "force=" + URLEncoder.encode(force, StandardCharsets.UTF_8);
                }
                Future response2 = client.target(new URI(remoteServerUrl)).request(new String[]{"application/json"}).header("X-Active-Active", (Object)this.coreBundleConfigurationTracker.getService().getServerUUID()).build("PUT").submit(Response.class);
                response = (Response)response2.get(60L, TimeUnit.SECONDS);
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        client.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.error("Could not set the remote server property value.", (Throwable)ex);
                    return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                }
            }
            client.close();
        }
        return response;
    }
}

