/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.IdentityProviderMappingsApplyer;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.PasswordValidatorImpl;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="im")
@Tag(name="Identity Management API", description="These are the identity management endpoints. Please note, that not all functions are supported\nby all identity providers. In case a function is not supported, a UnsupportedOperationException\ngets thrown. All calls - except the GET methods - are logged in the audit log.\n")
public class IdentityManagementEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(IdentityManagementEndpoint.class);
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=UTF-8";
    public static final String ROLE_IDENTITY_MANAGER_ADMIN = "IDENTITY_MANAGER_ADMIN";
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public IdentityManagementEndpoint(BundleContext bundleContext) {
        LOGGER.info("IdentityManagementEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return (CoreModule)this.moduleManagerTracker.getService().getModuleById("_core");
    }

    private UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() throws IdentityProviderException {
        LOGGER.debug("getUnsupportedIdentityProviderOperationsFallbackHandler");
        IdentityProvider idp = this.getIdentityProvider();
        if (idp instanceof IdentityProviderWithUnsupportedOperationsFallbackHandler) {
            return ((IdentityProviderWithUnsupportedOperationsFallbackHandler)((Object)idp)).getUnsupportedIdentityProviderOperationsFallbackHandler();
        }
        return null;
    }

    private IdentityProvider getIdentityProvider() throws IdentityProviderException {
        LOGGER.debug("getIdentityProvider");
        try {
            IdentityProvider identityProvider = this.getCoreModule().getIdentityProvider();
            if (identityProvider == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_NOT_FOUND, "No identity provider found");
            }
            return identityProvider;
        }
        catch (ModuleNotFoundException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No core module found. This should never happen. I AM THE CORE!");
        }
        catch (ServiceNotFoundException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "ModuleManager service not found");
        }
    }

    private IdentityManager getIdentityManager() throws IdentityManagerException {
        LOGGER.debug("getIdentityManager");
        try {
            IdentityManager identityManager = this.getCoreModule().getIdentityManager();
            if (identityManager == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_NOT_FOUND, "No identity manager found");
            }
            return identityManager;
        }
        catch (ModuleNotFoundException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "No core module found. This should never happen. I AM THE CORE!");
        }
        catch (ServiceNotFoundException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "ModuleManager service not found");
        }
    }

    private boolean isValidPassword(String password) {
        LOGGER.info("isValidPassword password=...");
        try {
            PasswordValidatorImpl passwordValidator = new PasswordValidatorImpl(this.getCoreModule().getCurrentIdentityProviderConfiguration());
            return passwordValidator.isValid(password);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to check the given password.", (Throwable)ex);
            return false;
        }
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get a list of all users as JSON.", description="Get a list of all users as JSON.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users, query-users\n")
    @ReturnDescription(value="The requested data as JSON.\n\n.Example response\n[source,json]\n----\n[\n   {\n     \"id\": \"bpcadmin\",\n     \"userName\": \"bpcadmin\",\n     \"displayName\": \"bpcadmin\",\n     \"firstName\": \"Timo\",\n     \"lastName\": \"Virt\",\n     \"email\": \"bpcadmin@example.com\"\n   },\n   {\n     \"id\": \"of\",\n     \"userName\": \"of\",\n     \"displayName\": \"of\",\n     \"firstName\": \"Oliver\",\n     \"lastName\": \"F\u00fcrni\u00df\",\n     \"email\": \"of@virtimo.de\"\n   }\n]\n----\n")
    public Response getUsers(@Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getUsers");
        try {
            return Response.ok(this.getIdentityManager().getUsers(userSession, req)).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Add a user.", description="Add a user by providing the data as JSON in the body.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users\n\n.Example body\n[source,json]\n----\n{\n   \"id\": \"42\",\n   \"password\": \"1234567890\",\n   \"firstName\": \"Hans\",\n   \"lastName\": \"Schmidt\",\n   \"email\": \"hans.schmidt@example.com\"\n}\n----\n")
    @POST
    @Path(value="/users")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_ADD", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory password not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUser(Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("addUser");
        try {
            String userId = (String)jsonMap.get("id");
            String password = (String)jsonMap.get("password");
            String firstName = (String)jsonMap.getOrDefault("firstName", "");
            String lastName = (String)jsonMap.getOrDefault("lastName", "");
            String email = (String)jsonMap.getOrDefault("email", "");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (!this.isValidPassword(password)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User password does not meet the requirements");
            }
            User user = UserFactory.getUser(userId, firstName + " " + lastName, firstName, lastName, email);
            this.getIdentityManager().addUser(userSession, req, user, password);
            UserAuditLog.info(userSession, "addUser", "New user added", null, (Object)user);
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Update a user.", description="Update a user by providing the data as JSON in the body.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users\n\n.Example body\n[source,json]\n----\n{\n   \"firstName\": \"Hans\",\n   \"lastName\": \"Test\",\n   \"email\": \"hans.test@example.com\"\n}\n----\n")
    @PUT
    @Path(value="/users/{userId}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response updateUser(@Parameter(description="the ID of the user to update") @PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("updateUser");
        try {
            String firstName = (String)jsonMap.getOrDefault("firstName", "");
            String lastName = (String)jsonMap.getOrDefault("lastName", "");
            String email = (String)jsonMap.getOrDefault("email", "");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            User oldUser = null;
            try {
                oldUser = this.getIdentityManager().getUser(userSession, req, userId);
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to get the old user data ({}) for audit logging.", (Object)userId, (Object)ex);
            }
            User user = UserFactory.getUser(userId, firstName + " " + lastName, firstName, lastName, email);
            this.getIdentityManager().updateUser(userSession, req, user);
            UserAuditLog.info(userSession, "updateUser", "User '" + userId + "' updated", (Object)oldUser, (Object)user);
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Update the password of a user.", description="Update the password of a user.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users\n\n.Example form\n[source]\n----\npassword=<new password>\n----\n")
    @PATCH
    @Path(value="/users/{userId}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory user password not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response updateUserPassword(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Parameter(description="the users new password") @FormParam(value="password") String newPassword, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("updateUserPassword");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (!this.isValidPassword(newPassword)) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "Password does not meet the requirements");
            }
            this.getIdentityManager().updateUserPassword(userSession, req, userId, newPassword);
            UserAuditLog.info(userSession, "updateUserPassword", "Password of user '" + userId + "' changed.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Delete a user.", description="Delete a user.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users\n")
    public Response deleteUser(@Parameter(description="the ID of the user to delete") @PathParam(value="userId") String userId, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteUser userId={}", (Object)userId);
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            this.getIdentityManager().deleteUser(userSession, req, userId);
            UserAuditLog.info(userSession, "deleteUser", "User '" + userId + "' deleted");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/organisations")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get all organisations.", description="Get all organisations as a JSON array.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users, view-users, query-groups\n")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"virtimo\",\n   \"users\",\n   \"admins\"\n]\n----\n")
    public Response getOrganisations(@Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getOrganisations");
        try {
            HashSet<Organisation> organisations = new HashSet<Organisation>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                organisations.addAll(handler.getManuallySetOrganisationsFromIdpMappings());
                try {
                    organisations.addAll(this.getIdentityManager().getOrganisations(userSession, req));
                    return Response.ok(organisations).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!organisations.isEmpty()) return Response.ok(organisations).build();
                    throw ex;
                }
            } else {
                organisations.addAll(this.getIdentityManager().getOrganisations(userSession, req));
            }
            return Response.ok(organisations).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/roles")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get all roles.", description="Get all roles as a JSON array.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-realm, view-realm, query-clients, query-users, query-groups, query-realms, manage-clients, view-clients\n")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"offline_access\",\n   \"uma_authorization\",\n   \"uma_protection\",\n   \"bpcadmin\",\n   \"bpcuser\"\n]\n----\n")
    public Response getRoles(@Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getRoles");
        try {
            HashSet<Role> roles = new HashSet<Role>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                roles.addAll(handler.getManuallySetRolesFromIdpMappings());
                try {
                    roles.addAll(this.getIdentityManager().getRoles(userSession, req));
                    return Response.ok(roles).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!roles.isEmpty()) return Response.ok(roles).build();
                    throw ex;
                }
            } else {
                roles.addAll(this.getIdentityManager().getRoles(userSession, req));
            }
            return Response.ok(roles).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/rights")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="No identity manager found or another failure"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get all rights.", description="Get all rights as a JSON array.")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"IDENTITY_MANAGER_USER_ORGANISATIONS_READ\",\n   \"CUSTOM_RIGHT\"\n]\n----\n")
    public Response getRights(@Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getRights");
        try {
            HashSet<Right> rights = new HashSet<Right>();
            UnsupportedIdentityProviderOperationsFallbackHandler handler = this.getUnsupportedIdentityProviderOperationsFallbackHandler();
            if (handler != null) {
                rights.addAll(handler.getManuallySetRightsFromIdpMappings());
                try {
                    rights.addAll(this.getIdentityManager().getRights(userSession, req));
                    return Response.ok(rights).build();
                }
                catch (Exception ex) {
                    if (!handler.isUnsupportedOperationException(ex)) throw ex;
                    if (!rights.isEmpty()) return Response.ok(rights).build();
                    throw ex;
                }
            } else {
                rights.addAll(this.getIdentityManager().getRights(userSession, req));
            }
            return Response.ok(rights).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/organisations")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_ORGANISATIONS_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* User does not exist\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get the organisations of a user.", description="Get the organisations of a user as JSON a array.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users, (view-users AND query-users)\n")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"virtimo\"\n]\n----\n")
    public Response getUserOrganisations(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getUserOrganisations userId:{}", (Object)userId);
        try {
            return Response.ok(this.getUserResponse(userSession, userId, req).getOrganisations()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Add an organisation to a user.", description="Add an organisation to a user by providing the data as JSON in the body.\n\n.Example body\n[source,json]\n----\n{\n   \"id\": \"virtimo\"\n}\n----\n")
    @POST
    @Path(value="/users/{userId}/organisations")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory organisation not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserOrganisation(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("addUserOrganisation");
        try {
            String organisationName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (organisationName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "organisationName missing");
            }
            this.getIdentityManager().addOrganisation(userSession, req, userId, organisationName);
            UserAuditLog.info(userSession, "addUserOrganisation", "Organisation '" + organisationName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/organisations/{organisationName}")
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory organisation not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Delete the organisation of a user.", description="Delete the organisation of a user.")
    public Response deleteUserOrganisation(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Parameter(description="the name of the organisation to delete") @PathParam(value="organisationName") String organisationName, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteUserOrganisation");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (organisationName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "organisationName missing");
            }
            this.getIdentityManager().deleteOrganisation(userSession, req, userId, organisationName);
            UserAuditLog.info(userSession, "deleteUserOrganisation", "Organisation '" + organisationName + "' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/roles")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_ROLES_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* User does not exist\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get the roles of a user.", description="Get the roles of a user as a JSON array.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users, (view-users AND query-users)\n")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"EAI Developer\",\n   \"System Administrator\"\n]\n----\n")
    public Response getUserRoles(@Parameter(description="the id of the user") @PathParam(value="userId") String userId, @Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getUserRoles userId:{}", (Object)userId);
        try {
            return Response.ok(this.getUserResponse(userSession, userId, req).getRoles()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Add a role to a user.", description="Add a role to a user by providing the data as JSON in the body.\n\n.Example body\n[source,json]\n----\n{\n   \"id\": \"EAI Developer\"\n}\n----\n")
    @POST
    @Path(value="/users/{userId}/roles")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory role not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserRole(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("addUserRole");
        try {
            String roleName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (roleName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "roleName missing");
            }
            this.getIdentityManager().addRole(userSession, req, userId, roleName);
            UserAuditLog.info(userSession, "addUserRole", "Role '" + roleName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/roles/{roleName}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory role not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Delete the role of a user.", description="Delete the role of a user.")
    public Response deleteUserRole(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Parameter(description="the name of the role to delete") @PathParam(value="roleName") String roleName, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteUserRole");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (roleName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "roleName missing");
            }
            this.getIdentityManager().deleteRole(userSession, req, userId, roleName);
            UserAuditLog.info(userSession, "deleteUserRole", "Role '" + roleName + "' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}/rights")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_RIGHTS_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* User does not exist\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get the rights of a user.", description="Get the rights of a user as a JSON array.")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n[\n   \"CUSTOM_RIGHT1\",\n   \"CUSTOM_RIGHT2\"\n]\n----\n")
    public Response getUserRights(@Parameter(description="the id of the user") @PathParam(value="userId") String userId, @Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getUserRights userId={}", (Object)userId);
        try {
            return Response.ok(this.getUserResponse(userSession, userId, req).getRights()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Add a right to a user.", description="Add a right to a user by providing the data as JSON in the body.\n\n.Example body\n[source,json]\n----\n{\n   \"id\": \"CUSTOM_RIGHT3\"\n}\n----\n")
    @POST
    @Path(value="/users/{userId}/rights")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory right not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    public Response addUserRight(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, Map<String, Object> jsonMap, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("addUserRight userId={}", (Object)userId);
        try {
            String rightName = (String)jsonMap.get("id");
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (rightName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "rightName missing");
            }
            this.getIdentityManager().addRight(userSession, req, userId, rightName);
            UserAuditLog.info(userSession, "addUserRight", "Right '" + rightName + "' added to user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to add user right.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/users/{userId}/rights/{rightName}")
    @Consumes(value={"application/json"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USERS_UPDATE", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* Mandatory user id not given\n* Mandatory right not given\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Delete the right of a user.", description="Delete the right of a user.")
    public Response deleteUserRight(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Parameter(description="the name of the right to delete") @PathParam(value="rightName") String rightName, @Context UserSession userSession, @Context HttpHeaders hh, @Context HttpServletRequest req) {
        LOGGER.info("deleteUserRight");
        try {
            if (userId == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "User id missing");
            }
            if (rightName == null) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "rightName missing");
            }
            this.getIdentityManager().deleteRight(userSession, req, userId, rightName);
            UserAuditLog.info(userSession, "deleteUserRight", "Right '" + rightName + "+' deleted from user '" + userId + "'.");
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/users/{userId}")
    @Produces(value={"application/json; charset=UTF-8"})
    @BpcRoleOrRightRequired(right="IDENTITY_MANAGER_USER_READ", role="IDENTITY_MANAGER_ADMIN")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="Failure due to one of the following reasons:\n\n* User does not exist\n* No identity manager found or another failure\n"), @ApiResponse(responseCode="503", description="Not supported by the used identity provider")})
    @OperationDescription(summary="Get the data of a user.", description="Get the data of a user.\n\nWhen used with Keycloak one of these Keycloak roles are needed: admin, realm-admin, manage-users, (query-users and view-users)\n")
    @ReturnDescription(value="The requested data.\n\n.Example response\n[source,json]\n----\n{\n   \"id\": \"66\",\n   \"userName\": \"of\",\n   \"firstName\": \"Oliver\",\n   \"lastName\": \"F\u00fcrni\u00df\",\n   \"displayName\": \"of\",\n   \"email\": \"of@virtimo.de\",\n   \"organisations\": [\n     \"virtimo\"\n   ],\n   \"roles\": [\n     \"bpcadmin\"\n   ],\n   \"rights\": [\n     \"loadModule_vam\",\n     \"loadModule_monitor\",\n     \"loadModule_dashboard\"\n   ]\n}\n----\n")
    public Response getUser(@Parameter(description="the ID of the user") @PathParam(value="userId") String userId, @Context HttpHeaders hh, @Context UserSession userSession, @Context HttpServletRequest req) {
        LOGGER.info("getUser userId={}", (Object)userId);
        try {
            return Response.ok((Object)this.getUserResponse(userSession, userId, req)).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private UserResponse getUserResponse(UserSession userSession, String userId, HttpServletRequest req) throws IdentityManagerException {
        LOGGER.info("getUserResponse userSession=..., userId={}", (Object)userId);
        IdentityManager identityManager = this.getIdentityManager();
        User user = identityManager.getUser(userSession, req, userId);
        if (user == null) {
            throw new UserNotFoundException(userId);
        }
        HashSet<Organisation> userOrganisations = new HashSet<Organisation>();
        try {
            Set<Organisation> userOrganisationsList = identityManager.getUserOrganisations(userSession, req, userId);
            if (userOrganisationsList != null) {
                userOrganisations.addAll(userOrganisationsList);
            }
        }
        catch (Throwable userOrganisationsList) {
            // empty catch block
        }
        if (userOrganisations.isEmpty()) {
            userOrganisations.add(OrganisationFactory.getDefaultOrganisation());
        }
        HashSet<Role> userRoles = new HashSet<Role>();
        try {
            Set<Role> userRolesList = identityManager.getUserRoles(userSession, req, userId);
            if (userRolesList != null) {
                userRoles.addAll(userRolesList);
            }
        }
        catch (Throwable userRolesList) {
            // empty catch block
        }
        userRoles.add(RolesFactory.getBpcUserRole());
        HashSet<Right> userRights = new HashSet<Right>();
        try {
            Set<Right> userRightsList = identityManager.getUserRights(userSession, req, userId);
            if (userRightsList != null) {
                userRights.addAll(userRightsList);
            }
        }
        catch (Throwable userRightsList) {
            // empty catch block
        }
        try {
            IdentityProviderMappings identityProviderMappings;
            IdentityProviderConfiguration idpConfiguration = this.getCoreModule().getCurrentIdentityProviderConfiguration();
            if (idpConfiguration != null && (identityProviderMappings = idpConfiguration.getIdentityProviderMappings()) != null) {
                IdentityProviderMappingsApplyer identityProviderMappingsApplyer = new IdentityProviderMappingsApplyer(userOrganisations, userRoles, userRights);
                identityProviderMappingsApplyer.applyIdentityProviderMappings(identityProviderMappings);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to apply the identity provider mappings.", (Throwable)ex);
        }
        return new UserResponse(user, userOrganisations, userRoles, userRights);
    }

    private static class UserResponse
    implements User {
        private final User user;
        private final Set<Organisation> organisations;
        private final Set<Role> roles;
        private final Set<Right> rights;

        public UserResponse(User user, Set<Organisation> organisations, Set<Role> roles, Set<Right> rights) {
            this.user = user;
            this.organisations = organisations;
            this.roles = roles;
            this.rights = rights;
        }

        @Override
        public String getId() {
            return this.user.getId();
        }

        @Override
        public String getUserName() {
            return this.user.getUserName();
        }

        @Override
        public String getDisplayName() {
            return this.user.getDisplayName();
        }

        @Override
        public String getFirstName() {
            return this.user.getFirstName();
        }

        @Override
        public String getLastName() {
            return this.user.getLastName();
        }

        @Override
        public String getEmail() {
            return this.user.getEmail();
        }

        public Set<Organisation> getOrganisations() {
            return this.organisations;
        }

        public Set<Role> getRoles() {
            return this.roles;
        }

        public Set<Right> getRights() {
            return this.rights;
        }
    }
}

