/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultReportService;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.api.security.Report;
import de.virtimo.bpc.api.security.UnknownCheck;
import de.virtimo.bpc.core.security.check.ReportImpl;
import de.virtimo.bpc.util.BoolUtil;
import de.virtimo.bpc.util.DictionaryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CheckResultReportServiceImpl
implements CheckResultReportService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(CheckResultReportServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<CheckResultStorageService> checkResultStorageServiceTracker;
    private final BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;

    public CheckResultReportServiceImpl(BundleContext bundleContext) {
        LOGGER.info("CheckResultReportServiceImpl activated");
        this.bundleContext = bundleContext;
        this.checkResultStorageServiceTracker = new BpcServicesTracker<CheckResultStorageService>(bundleContext, CheckResultStorageService.class);
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public Report getReport() throws ServiceNotFoundException {
        List<CheckResult> allCheckResults = this.checkResultStorageServiceTracker.getService().getLatestCheckResults();
        try (CheckCache checkCache = this.createCheckCache(allCheckResults);){
            List<CheckResult> activeCheckResults = this.filterIgnoredChecks(allCheckResults, checkCache.checks);
            LOGGER.debug("Report statistics: {} active checks, {} ignored checks, {} total checks", (Object)activeCheckResults.size(), (Object)(allCheckResults.size() - activeCheckResults.size()), (Object)allCheckResults.size());
            double score = this.calculateScore(activeCheckResults, checkCache.checks);
            ReportImpl reportImpl = new ReportImpl(activeCheckResults, score);
            return reportImpl;
        }
    }

    private List<CheckResult> filterIgnoredChecks(List<CheckResult> checkResults, Map<String, Check> checkCache) {
        LOGGER.debug("filterIgnoredChecks");
        return checkResults.stream().filter(checkResult -> !this.isCheckOrCheckResultIgnored((Check)checkCache.get(checkResult.getCheckId()), (CheckResult)checkResult)).collect(Collectors.toList());
    }

    private boolean isCheckOrCheckResultIgnored(Check check, CheckResult checkResult) {
        if (check instanceof UnknownCheck) {
            return true;
        }
        String ignorePropertyForCheckResult = checkResult.getIdentifier() + ".ignoreInReport";
        String ignorePropertyForCheck = check.getIdentifier() + ".ignoreInReport";
        Map properties = Collections.emptyMap();
        try {
            properties = Optional.ofNullable(this.configurationAdminTracker.getService().getConfiguration("de.virtimo.bpc.core.security.checks")).map(Configuration::getProperties).map(DictionaryUtil::convertToMap).orElse(Collections.emptyMap());
        }
        catch (ServiceNotFoundException | IOException e) {
            LOGGER.error("Failed to get filter configuration");
        }
        if (properties.containsKey(ignorePropertyForCheckResult)) {
            return BoolUtil.getBoolean(properties.get(ignorePropertyForCheckResult), Boolean.FALSE);
        }
        if (properties.containsKey(ignorePropertyForCheck)) {
            return BoolUtil.getBoolean(properties.get(ignorePropertyForCheck), Boolean.FALSE);
        }
        return false;
    }

    private double calculateScore(List<CheckResult> checkResults, Map<String, Check> checkCache) {
        if (checkResults.isEmpty()) {
            LOGGER.debug("No check results available, returning score 0.0");
            return 0.0;
        }
        int maxScore = checkResults.stream().mapToInt(cr -> ((Check)checkCache.get(cr.getCheckId())).getMaximumScore()).sum();
        int currentScore = checkResults.stream().mapToInt(CheckResult::getScore).sum();
        if (maxScore == 0) {
            LOGGER.warn("Maximum score is 0, cannot calculate meaningful score");
            return 0.0;
        }
        double score = (double)currentScore / (double)maxScore;
        LOGGER.debug("Score calculation: {}/{} = {}", (Object)currentScore, (Object)maxScore, (Object)score);
        return score;
    }

    private CheckCache createCheckCache(List<CheckResult> checkResults) {
        LOGGER.debug("Create check cache");
        HashMap<String, Check> checkCache = new HashMap<String, Check>();
        ArrayList<ServiceReference<Check>> serviceReferences = new ArrayList<ServiceReference<Check>>();
        for (CheckResult checkResult : checkResults) {
            if (checkCache.containsKey(checkResult.getCheckId())) continue;
            LOGGER.debug("Resolving Check for CheckResult {}", (Object)checkResult);
            Check check = null;
            try {
                Collection refs = this.bundleContext.getServiceReferences(Check.class, "(checkIdentifier=" + checkResult.getCheckId() + ")");
                serviceReferences.addAll(refs);
                if (!refs.isEmpty()) {
                    if (refs.size() > 1) {
                        LOGGER.warn("Found multiple checks for checkIdentifier {}. This could be an indicator of a memory leak or a bug. Using first one.", (Object)checkResult.getCheckId());
                    }
                    for (ServiceReference ref : refs) {
                        check = (Check)this.bundleContext.getService(ref);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not initialize CheckResolver", (Throwable)e);
            }
            if (check == null) {
                check = new UnknownCheck(checkResult.getCheckId());
            }
            checkCache.put(checkResult.getCheckId(), check);
        }
        return new CheckCache(this.bundleContext, checkCache, serviceReferences);
    }

    private record CheckCache(BundleContext bundleContext, Map<String, Check> checks, List<ServiceReference<Check>> serviceReferences) implements AutoCloseable
    {
        @Override
        public void close() {
            LOGGER.debug("release service reference for CheckCache");
            for (ServiceReference<Check> ref : this.serviceReferences) {
                try {
                    this.bundleContext.ungetService(ref);
                }
                catch (Exception e) {
                    LOGGER.error("error during unget service", (Throwable)e);
                }
            }
        }
    }
}

