/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.utils;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class FelixFileinstallUtil {
    public static File getDeployFolder(BundleContext bundleContext) throws InvalidSyntaxException, IOException, ServiceNotFoundException {
        Map<String, Object> felixFileinstallServiceConfig = FelixFileinstallUtil.getConfig(bundleContext);
        String deployFolderPath = MapUtil.getValueAsString(felixFileinstallServiceConfig, "felix.fileinstall.dir", null);
        return new File(deployFolderPath);
    }

    public static Map<String, Object> getConfig(BundleContext bundleContext) throws ServiceNotFoundException, IOException, InvalidSyntaxException {
        try (BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);){
            Configuration[] allConfigurations;
            for (Configuration configuration : allConfigurations = configurationAdminTracker.getService().listConfigurations(null)) {
                Dictionary props;
                if (!"org.apache.felix.fileinstall".equals(configuration.getFactoryPid()) || (props = configuration.getProcessedProperties(null)) == null) continue;
                Map<String, Object> map = DictionaryUtil.convertToMap(props);
                return map;
            }
            Configuration[] configurationArray = null;
            return configurationArray;
        }
    }
}

