/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.websocket;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.websocket.BpcWebsocket;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.osgi.framework.BundleContext;

public class BpcWebsocketServlet
extends WebSocketServlet {
    private static final Logger LOGGER = LogManager.getLogger(BpcWebsocketServlet.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker = null;
    private BpcServicesTracker<EventManager> eventManagerTracker = null;
    private BpcServicesTracker<IpPinningService> ipPinningServiceTracker = null;

    public BpcWebsocketServlet(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws ServletException {
        super.init();
        LOGGER.info("BpcWebsocketServlet initialized");
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);
        this.ipPinningServiceTracker = new BpcServicesTracker<IpPinningService>(this.bundleContext, IpPinningService.class);
    }

    public void destroy() {
        super.destroy();
        LOGGER.info("BpcWebsocketServlet destroyed");
        BpcServicesTracker.stopAll((Object)this);
    }

    public void configure(WebSocketServletFactory factory) {
        LOGGER.info("BpcWebsocketServlet configure");
        factory.getPolicy().setIdleTimeout(1800000L);
        factory.setCreator(new WebSocketCreator(){

            public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                try {
                    return new BpcWebsocket(BpcWebsocketServlet.this.clientSessionManagerTracker.getService(), BpcWebsocketServlet.this.eventManagerTracker.getService(), BpcWebsocketServlet.this.ipPinningServiceTracker.getService());
                }
                catch (Exception ex) {
                    throw new WebSocketException("Failed to instantiate the BPC websocket implementation: " + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }
}

