/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.flow;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.FlowService;
import de.virtimo.bpc.core.httpproxy.HttpProxyCall;
import de.virtimo.bpc.core.httpproxy.HttpProxyServiceImpl;
import de.virtimo.bpc.flow.FlowModule;
import de.virtimo.bpc.flow.FlowModuleInstance;
import de.virtimo.bpc.flow.HttpProxyCallConfigFromFlowInstance;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class FlowServiceImpl
implements FlowService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerBpcServicesTracker;

    public FlowServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.clientSessionManagerBpcServicesTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public ModuleConfiguration getConfig(String flowInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        FlowModule flowModule = (FlowModule)this.moduleManagerTracker.getService().getModuleById("flow");
        FlowModuleInstance flowInstance = (FlowModuleInstance)flowModule.getModuleInstanceById(flowInstanceId);
        return flowInstance.getConfiguration();
    }

    private HttpProxyCall getHttpProxyCallForFlowInstance(String flowInstanceId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        FlowModule flowModule = (FlowModule)this.moduleManagerTracker.getService().getModuleById("flow");
        FlowModuleInstance flowInstance = (FlowModuleInstance)flowModule.getModuleInstanceById(flowInstanceId);
        HttpProxyCallConfigFromFlowInstance config = new HttpProxyCallConfigFromFlowInstance(flowInstance);
        config.addAdditionalHttpHeader("X-BPC-Server-UUID", this.coreBundleConfigurationTracker.getService().getServerUUID());
        return new HttpProxyCall(config);
    }

    private String getNonHijackableSessionId(UserSession userSession) throws ServiceNotFoundException {
        if (userSession == null) {
            return null;
        }
        ClientSessionManager clientSessionManager = this.clientSessionManagerBpcServicesTracker.getService();
        return clientSessionManager.getNonHijackableSessionIdFromSessionId(userSession.getSessionId());
    }

    @Override
    public Response doGet(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doGet flowInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...=", (Object)flowInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doGet(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession));
    }

    @Override
    public Response doPost(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doPost flowInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...=", (Object)flowInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doPost(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession), body);
    }

    @Override
    public Response doPut(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession, byte[] body) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doPut flowInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=..., body=...=", (Object)flowInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doPut(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession), body);
    }

    @Override
    public Response doDelete(String flowInstanceId, String targetPath, String targetUrl, UriInfo uriInfo, HttpHeaders headers, UserSession userSession) throws HttpProxyException, ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOGGER.info("doDelete flowInstanceId={}, targetPath={}, targetUrl={}, uriInfo={}, headers=..., userSession=...=", (Object)flowInstanceId, (Object)targetPath, (Object)targetUrl, (Object)uriInfo);
        return this.getHttpProxyCallForFlowInstance(flowInstanceId).doDelete(targetPath, targetUrl, uriInfo, headers, userSession, this.getNonHijackableSessionId(userSession));
    }
}

