/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.jsonschema;

import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogDataJsonSchema {
    private static final Logger LOGGER = LogManager.getLogger(LogDataJsonSchema.class);
    private final String jsonSchemaAsString;
    private JsonSchema jsonSchema;

    public LogDataJsonSchema(String jsonSchemaAsString) {
        this.jsonSchemaAsString = jsonSchemaAsString;
        this.jsonSchema = null;
    }

    public String asString() {
        return this.jsonSchemaAsString;
    }

    public Map<String, Object> asMap() {
        try {
            return JsonUtil.asMap((String)this.jsonSchemaAsString);
        }
        catch (IOException ex) {
            LOGGER.error("Should not be possible, but could not parse JSON schema as Map.", (Throwable)ex);
            return null;
        }
    }

    public JsonSchema asJsonSchema() {
        if (this.jsonSchema == null) {
            this.jsonSchema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(this.jsonSchemaAsString);
        }
        return this.jsonSchema;
    }
}

