/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.logservice.jsonschema;

import de.virtimo.bpc.logservice.LogServiceModuleInstance;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchema;
import de.virtimo.bpc.logservice.jsonschema.LogDataJsonSchemaBuilder;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class LogDataJsonSchemaVariants {
    private final String bpcFrontendUrl;
    private final String logServiceInstanceId;
    private final LogServiceModuleInstance.KeysConfig keysConfig;
    private final LogServiceModuleInstance.FieldsConfig fieldsConfig;
    private final Map<String, LogDataJsonSchema> cache;

    public LogDataJsonSchemaVariants(String bpcFrontendUrl, String logServiceInstanceId, LogServiceModuleInstance.KeysConfig keysConfig, LogServiceModuleInstance.FieldsConfig fieldsConfig) {
        this.bpcFrontendUrl = bpcFrontendUrl;
        this.logServiceInstanceId = logServiceInstanceId;
        this.keysConfig = keysConfig;
        this.fieldsConfig = fieldsConfig;
        this.cache = new HashMap<String, LogDataJsonSchema>();
    }

    public LogDataJsonSchema get(boolean createStrictJsonSchema) {
        String cacheKey = this.createCacheKey(createStrictJsonSchema);
        if (!this.cache.containsKey(cacheKey)) {
            this.cache.put(cacheKey, this.createLogDataJsonSchema(createStrictJsonSchema));
        }
        return this.cache.get(cacheKey);
    }

    private String createCacheKey(boolean createStrictJsonSchema) {
        return "strict:" + createStrictJsonSchema;
    }

    private LogDataJsonSchema createLogDataJsonSchema(boolean createStrictJsonSchema) {
        return LogDataJsonSchemaBuilder.newInstance().withId(this.createSchemaId(createStrictJsonSchema)).withKeysConfig(this.keysConfig).withFieldsConfig(this.fieldsConfig).forStrictJsonSchema(createStrictJsonSchema).build();
    }

    private String createSchemaId(boolean createStrictJsonSchema) {
        if (this.bpcFrontendUrl == null || this.logServiceInstanceId == null) {
            return null;
        }
        Object jsonSchemaUrl = StringUtil.glue(this.bpcFrontendUrl, "/cxf/bpc-logservice/jsonschema/" + this.logServiceInstanceId, '/');
        if (createStrictJsonSchema) {
            jsonSchemaUrl = (String)jsonSchemaUrl + "?strict=true";
        }
        return jsonSchemaUrl;
    }
}

