/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AsciiDocToMarkdownUtil {
    public static String convertToMarkdown(@NotNull String input) {
        String convertedInput = input;
        convertedInput = AsciiDocToMarkdownUtil.replaceAsciiDocCodeBlocksWithTitles(convertedInput);
        convertedInput = AsciiDocToMarkdownUtil.replaceAllAsciiDocTables(convertedInput);
        convertedInput = AsciiDocToMarkdownUtil.convertAsciiDocDescriptionList(convertedInput);
        return convertedInput;
    }

    public static String replaceAsciiDocCodeBlocksWithTitles(String input) {
        Pattern pattern = Pattern.compile("(?sm)(?:^\\.(.+?)\\s*\\n)?\\[source(?:,(\\w+))?]\\s*----\\s*(.*?)\\s*----");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String title = matcher.group(1);
            String language = matcher.group(2);
            String codeContent = matcher.group(3).trim();
            StringBuilder replacement = new StringBuilder();
            if (title != null && !title.isBlank()) {
                replacement.append("### ").append(title.trim()).append("\n");
            }
            if (language != null) {
                replacement.append("```").append(language).append("\n");
            } else {
                replacement.append("```\n");
            }
            replacement.append(codeContent).append("\n```");
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement.toString()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String convertAsciiDocDescriptionList(String input) {
        Pattern pattern = Pattern.compile("^\\s*(.+?)\\s*::\\s*(.+)$", 8);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            String description = matcher.group(2);
            String replacement = "- **" + key + ":** " + description;
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String replaceAllAsciiDocTables(@NotNull String input) {
        Pattern pattern = Pattern.compile("(?s)!===.*?!===");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String matchedTable = matcher.group();
            String replacement = AsciiDocToMarkdownUtil.convertTable(matchedTable);
            replacement = Matcher.quoteReplacement(replacement);
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String convertTable(@NotNull String asciiDocTable) {
        StringBuilder sb = new StringBuilder();
        String[] lines = asciiDocTable.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = lines[i].trim();
        }
        if (lines.length < 3 && !lines[0].equals("!===") || !lines[lines.length - 1].equals("!===")) {
            return "";
        }
        String headerLine = lines[1];
        String[] headerCols = headerLine.split("!");
        int nColumns = headerCols.length - 1;
        sb.append("|");
        for (int iCol = 1; iCol < headerCols.length; ++iCol) {
            sb.append(" ").append(headerCols[iCol].trim()).append(" |");
        }
        sb.append("\n|");
        sb.append(" -- |".repeat(nColumns)).append("\n");
        int nCellsWritten = 0;
        for (int iLine = 2; iLine < lines.length - 1; ++iLine) {
            String line = lines[iLine];
            if (line.isEmpty()) continue;
            String[] lineCells = line.split("!");
            for (int iCol = 1; iCol < lineCells.length; ++iCol) {
                sb.append("| ").append(lineCells[iCol].trim()).append(" ");
                if (++nCellsWritten % nColumns != 0) continue;
                sb.append("|\n");
            }
        }
        if (!sb.isEmpty() && sb.charAt(sb.length() - 1) == '\n') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

