/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class BpcTrustStore {
    private static final Logger LOGGER = LogManager.getLogger(BpcTrustStore.class);
    private static BpcTrustStore INSTANCE = null;
    private static final Object TRUSTSTORE_LOCK = new Object();
    private KeyStore cachedTrustStore = null;
    private long cachedTrustStoreFileLastModified = -1L;

    private BpcTrustStore() {
    }

    public static BpcTrustStore getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BpcTrustStore();
        }
        return INSTANCE;
    }

    public static void destroySingleton() {
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getTrustStore(BundleContext bundleContext) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        LOGGER.info("getTrustStore bundleContext={}", (Object)bundleContext);
        Object object = TRUSTSTORE_LOCK;
        synchronized (object) {
            KeyStore keyStore;
            block14: {
                ServiceReference configurationAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
                try {
                    ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(configurationAdminServiceReference);
                    Configuration paxWebConf = configurationAdmin.getConfiguration("org.ops4j.pax.web");
                    Object trustStorePath = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.truststore");
                    Object trustStorePassword = paxWebConf.getProcessedProperties(null).get("org.ops4j.pax.web.ssl.truststore.password");
                    File trustStoreFile = new File((String)trustStorePath);
                    long trustStoreFileLastModified = trustStoreFile.lastModified();
                    if (this.cachedTrustStore == null || trustStoreFileLastModified != this.cachedTrustStoreFileLastModified) {
                        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        try (FileInputStream is = new FileInputStream(trustStoreFile);){
                            trustStore.load(is, ((String)trustStorePassword).toCharArray());
                        }
                        this.cachedTrustStore = trustStore;
                        this.cachedTrustStoreFileLastModified = trustStoreFileLastModified;
                    }
                    keyStore = this.cachedTrustStore;
                    if (configurationAdminServiceReference == null) break block14;
                }
                catch (Throwable throwable) {
                    if (configurationAdminServiceReference != null) {
                        bundleContext.ungetService(configurationAdminServiceReference);
                    }
                    throw throwable;
                }
                bundleContext.ungetService(configurationAdminServiceReference);
            }
            return keyStore;
        }
    }

    public SSLContext getBpcSslContext() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager bpcTrustManager = this.getBpcTrustManager();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{bpcTrustManager}, new SecureRandom());
        return sslContext;
    }

    public void setTo(WebClient webClient, boolean allowUntrustedConnections) throws NoSuchAlgorithmException, KeyStoreException {
        LOGGER.info("setTo webClient=..., allowUntrustedConnections={}", (Object)allowUntrustedConnections);
        if (webClient != null) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            TLSClientParameters params = conduit.getTlsClientParameters();
            if (params == null) {
                params = new TLSClientParameters();
                conduit.setTlsClientParameters(params);
            }
            if (allowUntrustedConnections) {
                LOGGER.debug("Skip remote host certificate check on https");
                X509ExtendedTrustManager trustAllCertsTrustManager = this.getExtendedTrustAllCertsTrustManager();
                params.setTrustManagers(new TrustManager[]{trustAllCertsTrustManager});
                params.setDisableCNCheck(true);
            } else {
                LOGGER.debug("Set custom BPC trust manager");
                X509TrustManager bpcTrustManager = this.getBpcTrustManager();
                params.setTrustManagers(new TrustManager[]{bpcTrustManager});
            }
        }
    }

    public void setTo(URLConnection conn) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        LOGGER.info("setTo conn=...");
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            SSLContext sslContext = this.getBpcSslContext();
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            httpsConn.setSSLSocketFactory(sslSocketFactory);
        }
    }

    public void setTo(HTTPRequest httpRequest) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        LOGGER.info("setTo httpRequest=...");
        if (httpRequest != null) {
            SSLContext sslContext = this.getBpcSslContext();
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            httpRequest.setSSLSocketFactory(sslSocketFactory);
        }
    }

    public X509TrustManager getBpcTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOGGER.debug("getBpcTrustManager");
        final X509TrustManager defaultTrustManager = this.getDefaultTrustManager();
        final X509TrustManager virtimoTrustManager = this.getVirtimoTrustManager();
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return defaultTrustManager.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    virtimoTrustManager.checkServerTrusted(chain, authType);
                }
                catch (Exception e) {
                    defaultTrustManager.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                defaultTrustManager.checkClientTrusted(chain, authType);
            }
        };
    }

    private X509TrustManager getDefaultTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOGGER.debug("getDefaultTrustManager");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            X509TrustManager x509tm = (X509TrustManager)tm;
            return x509tm;
        }
        return null;
    }

    private X509TrustManager getVirtimoTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        LOGGER.debug("getVirtimoTrustManager");
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(BpcTrustStore.class).getBundleContext();
            KeyStore bpcTrustStore = this.getTrustStore(bundleContext);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(bpcTrustStore);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager x509tm = (X509TrustManager)tm;
                return x509tm;
            }
        }
        catch (NullPointerException e) {
            LOGGER.warn("Could not find name of trust store, 'org.ops4j.pax.web.ssl.truststore' is not set", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find virtimo trust store (virtimo_truststore.jks in [karaf]/etc/virtimo/ssl)", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Error while loading virtimo trust store. Password might be invalid", (Throwable)e);
        }
        catch (CertificateException e) {
            LOGGER.warn("Virtimo trust store Certificate exception", (Throwable)e);
        }
        return null;
    }

    public X509TrustManager getTrustAllCertsTrustManager() {
        LOGGER.debug("getTrustAllCertsTrustManager");
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public X509ExtendedTrustManager getExtendedTrustAllCertsTrustManager() {
        LOGGER.debug("getExtendedTrustAllCertsTrustManager");
        return new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
    }
}

