/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.util.BoolUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MapUtil {
    public static Map<String, Object> mapOf(Object ... keyValuePairs) throws IllegalArgumentException {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("keyValuePairs must be given as pairs of 2");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object key = keyValuePairs[i];
            Object value = keyValuePairs[i + 1];
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Keys must be of type String");
            }
            String keyAsString = (String)key;
            result.put(keyAsString, value);
        }
        return result;
    }

    @NotNull
    public static Map<String, Object> getEntriesWithKeyPrefix(Map<String, Object> map, String keyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((key, value) -> {
            if (key.startsWith(keyPrefix)) {
                result.put((String)key, value);
            }
        });
        return result;
    }

    public static int getValueAsInt(Map dataMap, String key, int defaultValue) {
        block5: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Integer)value;
                }
                catch (Exception e) {
                    if (!(value instanceof String)) break block5;
                    String valueAsString = (String)value;
                    try {
                        return Integer.parseInt(valueAsString);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defaultValue;
    }

    public static long getValueAsLong(Map dataMap, String key, long defaultValue) {
        block6: {
            Object value;
            if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
                try {
                    return (Long)value;
                }
                catch (Exception e) {
                    if (value instanceof String) {
                        String valueAsString = (String)value;
                        try {
                            return Long.parseLong(valueAsString);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    if (!(value instanceof Integer)) break block6;
                    Integer valueAsInteger = (Integer)value;
                    return valueAsInteger.longValue();
                }
            }
        }
        return defaultValue;
    }

    public static boolean getValueAsBoolean(Map dataMap, String key, boolean defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            return BoolUtil.getBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    public static String getValueAsString(Map dataMap, String key, String defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            try {
                return (String)dataMap.get(key);
            }
            catch (Exception e) {
                try {
                    return String.valueOf(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public static String[] getValueAsStringArray(Map dataMap, String key, String[] defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof List) {
            List valueAsList = (List)value;
            try {
                return valueAsList.toArray(new String[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static List getValueAsList(Map dataMap, String key, List defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof List) {
            List valueAsList = (List)value;
            return valueAsList;
        }
        return defaultValue;
    }

    public static Set getValueAsSet(Map dataMap, String key, Set defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null) {
            if (value instanceof Set) {
                Set valueAsSet = (Set)value;
                return valueAsSet;
            }
            if (value instanceof List) {
                List valueAsList = (List)value;
                return new HashSet(valueAsList);
            }
        }
        return defaultValue;
    }

    public static Map getValueAsMap(Map dataMap, String key, Map defaultValue) {
        Object value;
        if (dataMap != null && key != null && (value = dataMap.get(key)) != null && value instanceof Map) {
            Map valueAsMap = (Map)value;
            return valueAsMap;
        }
        return defaultValue;
    }

    public static Object getValueAsObject(Map dataMap, String key, Object defaultValue) {
        if (dataMap != null && key != null) {
            return dataMap.get(key);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> deepCopy(Map<K, V> originalMap) throws IOException {
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            String originalMapAsJsonString = mapper.writeValueAsString(originalMap);
            Map map = (Map)mapper.readValue(originalMapAsJsonString, new TypeReference<Map<K, V>>(){});
            return map;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public static <K, V> Map<K, V> merge(Map<K, V> thisMap, Map<K, V> intoThisMap) {
        HashMap<K, V> result = new HashMap<K, V>();
        if (intoThisMap != null) {
            result.putAll(intoThisMap);
        }
        if (thisMap != null) {
            result.putAll(thisMap);
        }
        return result;
    }
}

