/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class StringUtil {
    private StringUtil() {
    }

    @NotNull
    public static String implode(String glue, String[] pieces) {
        StringBuilder result = new StringBuilder();
        if (pieces != null && pieces.length > 0) {
            for (int i = 0; i < pieces.length; ++i) {
                String piece = pieces[i];
                if (piece != null) {
                    result.append(piece);
                }
                if (glue == null || i >= pieces.length - 1) continue;
                result.append(glue);
            }
        }
        return result.toString();
    }

    @NotNull
    public static String implode(String glue, Collection<String> pieces) {
        return StringUtil.implode(glue, pieces == null ? null : pieces.toArray(new String[0]));
    }

    public static List<String> explode(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        if (delimiter == null || delimiter.length() == 0) {
            return Arrays.asList(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimiter);
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static Map<String, Object> formParamsAsMap(String urlencoded) {
        Objects.requireNonNull(urlencoded, "urlencoded cannot be null");
        return StringUtil.formParamsAsMap(urlencoded, StandardCharsets.UTF_8);
    }

    public static Map<String, Object> formParamsAsMap(String urlencoded, String encoding) throws UnsupportedEncodingException {
        Objects.requireNonNull(urlencoded, "urlencoded cannot be null");
        Objects.requireNonNull(encoding, "charset cannot be null");
        try {
            Charset encodingCharset = Charset.forName(encoding);
            return StringUtil.formParamsAsMap(urlencoded, encodingCharset);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public static Map<String, Object> formParamsAsMap(String urlencoded, Charset charset) {
        Objects.requireNonNull(urlencoded, "urlencoded cannot be null");
        Objects.requireNonNull(charset, "charset cannot be null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String keyValue : urlencoded.trim().split("&")) {
            String[] tokens = keyValue.trim().split("=");
            String key = tokens[0];
            String value = tokens.length == 1 ? null : URLDecoder.decode(tokens[1], charset);
            map.put(key, value);
        }
        return map;
    }

    public static String removeLeadingCharacters(String s, char c) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() >= 1 && sb.charAt(0) == c) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String removeTailingCharacters(String s, char c) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() >= 1 && sb.charAt(sb.length() - 1) == c) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String glue(String head, String tail, char glue) {
        String cleanedUpTail;
        if (head == null && tail == null) {
            return null;
        }
        String cleanedUpHead = head == null ? "" : StringUtil.removeTailingCharacters(head.trim(), glue);
        String string = cleanedUpTail = tail == null ? "" : StringUtil.removeLeadingCharacters(tail.trim(), glue);
        if (cleanedUpTail.equals("")) {
            return cleanedUpHead;
        }
        return cleanedUpHead + glue + cleanedUpTail;
    }

    public static String toSHA1(String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(value.getBytes(StandardCharsets.UTF_8));
            return String.format("%040x", new BigInteger(1, digest.digest()));
        }
        catch (Exception ex) {
            return "<error>";
        }
    }
}

