/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="java.io.File: RAFDirectory is legacy API")
public class RAFDirectory
extends FSDirectory {
    public RAFDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
        path.toFile();
    }

    public RAFDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        File path = this.directory.resolve(name).toFile();
        RandomAccessFile raf = new RandomAccessFile(path, "r");
        return new RAFIndexInput("SimpleFSIndexInput(path=\"" + path.getPath() + "\")", raf, context);
    }

    @SuppressForbidden(reason="java.io.File: RAFDirectory is legacy API")
    static final class RAFIndexInput
    extends BufferedIndexInput {
        private static final int CHUNK_SIZE = 8192;
        protected final RandomAccessFile file;
        boolean isClone = false;
        protected final long off;
        protected final long end;

        public RAFIndexInput(String resourceDesc, RandomAccessFile file, IOContext context) throws IOException {
            super(resourceDesc, context);
            this.file = file;
            this.off = 0L;
            this.end = file.length();
        }

        public RAFIndexInput(String resourceDesc, RandomAccessFile file, long off, long length, int bufferSize) {
            super(resourceDesc, bufferSize);
            this.file = file;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        public RAFIndexInput clone() {
            RAFIndexInput clone = (RAFIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            if ((length | offset) < 0L || length > this.length() - offset) {
                throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + String.valueOf(this));
            }
            return new RAFIndexInput(sliceDescription, this.file, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(ByteBuffer b) throws IOException {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                long position = this.off + this.getFilePointer();
                this.file.seek(position);
                if (position + (long)b.remaining() > this.end) {
                    throw new EOFException("read past EOF: " + String.valueOf(this));
                }
                try {
                    while (b.hasRemaining()) {
                        int toRead = Math.min(8192, b.remaining());
                        int i = this.file.read(b.array(), b.position(), toRead);
                        if (i < 0) {
                            throw new EOFException("read past EOF: " + String.valueOf(this) + " off: " + b.position() + " len: " + b.remaining() + " chunkLen: " + toRead + " end: " + this.end);
                        }
                        assert (i > 0) : "RandomAccessFile.read with non zero-length toRead must always read at least one byte";
                        b.position(b.position() + i);
                    }
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + String.valueOf(this), ioe);
                }
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
            if (pos > this.length()) {
                throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + String.valueOf(this));
            }
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }
    }
}

