/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.sandbox.search.SortedSetDocValuesMultiRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public final class DocValuesMultiRangeQuery {
    private DocValuesMultiRangeQuery() {
    }

    public static class SortedSetStabbingBuilder {
        protected final String fieldName;
        protected final List<ByteRange> clauses = new ArrayList<ByteRange>();

        public SortedSetStabbingBuilder(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName);
        }

        public SortedSetStabbingBuilder add(BytesRef lowerValue, BytesRef upperValue) {
            this.clauses.add(new ByteRange(lowerValue, upperValue));
            return this;
        }

        public SortedSetStabbingBuilder add(BytesRef singleValue) {
            this.clauses.add(new ByteRange(singleValue));
            return this;
        }

        public Query build() {
            if (this.clauses.isEmpty()) {
                return new MatchNoDocsQuery();
            }
            if (this.clauses.size() == 1) {
                ByteRange theOnlyOne = this.clauses.getFirst();
                return SortedSetDocValuesField.newSlowRangeQuery(this.fieldName, theOnlyOne.lower, theOnlyOne.upper, true, true);
            }
            return this.createSortedSetDocValuesMultiRangeQuery();
        }

        protected Query createSortedSetDocValuesMultiRangeQuery() {
            return new SortedSetDocValuesMultiRangeQuery(this.fieldName, this.clauses);
        }
    }

    public static class ByteRange {
        protected BytesRef lower;
        protected BytesRef upper;

        public ByteRange(BytesRef lowerValue, BytesRef upperValue) {
            this.lower = BytesRef.deepCopyOf(lowerValue);
            this.upper = BytesRef.deepCopyOf(upperValue);
        }

        public ByteRange(BytesRef singleValue) {
            this.upper = this.lower = BytesRef.deepCopyOf(singleValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteRange that = (ByteRange)o;
            return this.lower.equals(that.lower) && this.upper.equals(that.upper);
        }

        public int hashCode() {
            int result = this.lower.hashCode();
            result = 31 * result + this.upper.hashCode();
            return result;
        }

        public String toString() {
            return String.valueOf(this.lower) + ".." + String.valueOf(this.upper);
        }
    }
}

