/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalsCollector
implements Collector {
    final String field;
    final LongBitSet collectedOrds;
    final OrdinalMap ordinalMap;

    GlobalOrdinalsCollector(String field, OrdinalMap ordinalMap, long valueCount) {
        this.field = field;
        this.ordinalMap = ordinalMap;
        this.collectedOrds = new LongBitSet(valueCount);
    }

    public LongBitSet getCollectorOrdinals() {
        return this.collectedOrds;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        SortedDocValues docTermOrds = DocValues.getSorted(context.reader(), this.field);
        if (this.ordinalMap != null) {
            LongValues segmentOrdToGlobalOrdLookup = this.ordinalMap.getGlobalOrds(context.ord);
            return new OrdinalMapCollector(docTermOrds, segmentOrdToGlobalOrdLookup);
        }
        return new SegmentOrdinalCollector(docTermOrds);
    }

    final class OrdinalMapCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;
        private final LongValues segmentOrdToGlobalOrdLookup;

        OrdinalMapCollector(SortedDocValues docTermOrds, LongValues segmentOrdToGlobalOrdLookup) {
            this.docTermOrds = docTermOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.docTermOrds.advanceExact(doc)) {
                long segmentOrd = this.docTermOrds.ordValue();
                long globalOrd = this.segmentOrdToGlobalOrdLookup.get(segmentOrd);
                GlobalOrdinalsCollector.this.collectedOrds.set(globalOrd);
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    final class SegmentOrdinalCollector
    implements LeafCollector {
        private final SortedDocValues docTermOrds;

        SegmentOrdinalCollector(SortedDocValues docTermOrds) {
            this.docTermOrds = docTermOrds;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.docTermOrds.advanceExact(doc)) {
                GlobalOrdinalsCollector.this.collectedOrds.set(this.docTermOrds.ordValue());
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
        }
    }
}

