/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsCollector<DV>
extends DocValuesTermsCollector<DV> {
    final BytesRefHash collectorTerms = new BytesRefHash();

    TermsCollector(DocValuesTermsCollector.Function<DV> docValuesCall) {
        super(docValuesCall);
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    static TermsCollector<?> create(String field, boolean multipleValuesPerDocument) {
        return multipleValuesPerDocument ? new MV(TermsCollector.sortedSetDocValues(field)) : new SV(TermsCollector.sortedDocValues(field));
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    static class MV
    extends TermsCollector<SortedSetDocValues> {
        MV(DocValuesTermsCollector.Function<SortedSetDocValues> docValuesCall) {
            super(docValuesCall);
        }

        @Override
        public void collect(int doc) throws IOException {
            if (doc > ((SortedSetDocValues)this.docValues).docID()) {
                ((SortedSetDocValues)this.docValues).advance(doc);
            }
            if (doc == ((SortedSetDocValues)this.docValues).docID()) {
                for (int i = 0; i < ((SortedSetDocValues)this.docValues).docValueCount(); ++i) {
                    BytesRef term = ((SortedSetDocValues)this.docValues).lookupOrd(((SortedSetDocValues)this.docValues).nextOrd());
                    this.collectorTerms.add(term);
                }
            }
        }
    }

    static class SV
    extends TermsCollector<SortedDocValues> {
        SV(DocValuesTermsCollector.Function<SortedDocValues> docValuesCall) {
            super(docValuesCall);
        }

        @Override
        public void collect(int doc) throws IOException {
            BytesRef term = ((SortedDocValues)this.docValues).advanceExact(doc) ? ((SortedDocValues)this.docValues).lookupOrd(((SortedDocValues)this.docValues).ordValue()) : new BytesRef(BytesRef.EMPTY_BYTES);
            this.collectorTerms.add(term);
        }
    }
}

