/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query must not match any docs besides parent filter. Combine them as must (+) and must-not (-) clauses to find a problem doc. docID=";
    static final String ILLEGAL_ADVANCE_ON_PARENT = "Expect to be advanced on child docs only. got docID=";
    private final BitSetProducer parentsFilter;
    private final Query parentQuery;

    public ToChildBlockJoinQuery(Query parentQuery, BitSetProducer parentsFilter) {
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher, scoreMode, boost), this.parentsFilter, scoreMode.needsScores());
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(indexSearcher);
        if (parentRewrite != this.parentQuery) {
            return new ToChildBlockJoinQuery(parentRewrite, this.parentsFilter);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ToChildBlockJoinQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(ToChildBlockJoinQuery other) {
        return this.parentQuery.equals(other.parentQuery) && this.parentsFilter.equals(other.parentsFilter);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.parentQuery.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    private static class ToChildBlockJoinWeight
    extends FilterWeight {
        private final BitSetProducer parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, BitSetProducer parentsFilter, boolean doScores) {
            super(joinQuery, parentWeight);
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext readerContext) throws IOException {
            Scorer parentScorer = this.in.scorer(readerContext);
            if (parentScorer == null) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            ToChildBlockJoinScorer scorer = new ToChildBlockJoinScorer(parentScorer, parents, this.doScores);
            return new Weight.DefaultScorerSupplier(scorer);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            ToChildBlockJoinScorer scorer = (ToChildBlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                int parentDoc = scorer.getParentDoc();
                return Explanation.match((Number)Float.valueOf(scorer.score()), String.format(Locale.ROOT, "Score based on parent document %d", parentDoc + context.docBase), this.in.explain(context, parentDoc));
            }
            return Explanation.noMatch("Not a match", new Explanation[0]);
        }
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final DocIdSetIterator parentIt;
        private final BitSet parentBits;
        private final boolean doScores;
        private float parentScore;
        private int childDoc = -1;
        private int parentDoc = 0;

        public ToChildBlockJoinScorer(Scorer parentScorer, BitSet parentBits, boolean doScores) {
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.parentIt = parentScorer.iterator();
        }

        @Override
        public Collection<Scorable.ChildScorable> getChildren() {
            return Collections.singleton(new Scorable.ChildScorable(this.parentScorer, "BLOCK_JOIN"));
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                @Override
                public int docID() {
                    return childDoc;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (childDoc + 1 == parentDoc) {
                        do {
                            parentDoc = parentIt.nextDoc();
                            this.validateParentDoc();
                            if (parentDoc == 0) {
                                parentDoc = parentIt.nextDoc();
                                this.validateParentDoc();
                            }
                            if (parentDoc == Integer.MAX_VALUE) {
                                childDoc = Integer.MAX_VALUE;
                                return childDoc;
                            }
                            childDoc = 1 + parentBits.prevSetBit(parentDoc - 1);
                        } while (childDoc == parentDoc || childDoc >= parentDoc);
                        if (doScores) {
                            parentScore = parentScorer.score();
                        }
                        return childDoc;
                    }
                    assert (childDoc < parentDoc) : "childDoc=" + childDoc + " parentDoc=" + parentDoc;
                    ++childDoc;
                    return childDoc;
                }

                @Override
                public int advance(int childTarget) throws IOException {
                    if (childTarget >= parentDoc) {
                        int firstChild;
                        block7: {
                            if (childTarget == Integer.MAX_VALUE) {
                                parentDoc = Integer.MAX_VALUE;
                                childDoc = Integer.MAX_VALUE;
                                return Integer.MAX_VALUE;
                            }
                            parentDoc = parentIt.advance(childTarget + 1);
                            this.validateParentDoc();
                            if (parentDoc == Integer.MAX_VALUE) {
                                childDoc = Integer.MAX_VALUE;
                                return Integer.MAX_VALUE;
                            }
                            do {
                                if ((firstChild = parentBits.prevSetBit(parentDoc - 1) + 1) != parentDoc) break block7;
                                parentDoc = parentIt.nextDoc();
                                this.validateParentDoc();
                            } while (parentDoc != Integer.MAX_VALUE);
                            childDoc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        childTarget = Math.max(childTarget, firstChild);
                        if (doScores) {
                            parentScore = parentScorer.score();
                        }
                    }
                    assert (childTarget < parentDoc);
                    assert (!parentBits.get(childTarget));
                    childDoc = childTarget;
                    return childDoc;
                }

                @Override
                public long cost() {
                    return parentIt.cost();
                }
            };
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        @Override
        public int docID() {
            return this.childDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        int getParentDoc() {
            return this.parentDoc;
        }
    }
}

