/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.suggest.InMemorySorter;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.search.suggest.fst.FSTCompletion;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.NoOutputs;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class FSTCompletionBuilder {
    public static final int DEFAULT_BUCKETS = 10;
    private final int buckets;
    FST<Object> automaton;
    private final BytesRefSorter sorter;
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private final double suffixRAMLimitMB;

    public FSTCompletionBuilder() {
        this(10, new InMemorySorter(Comparator.naturalOrder()), Double.POSITIVE_INFINITY);
    }

    public FSTCompletionBuilder(int buckets, BytesRefSorter sorter, double suffixRAMLimitMB) {
        if (buckets < 1 || buckets > 255) {
            throw new IllegalArgumentException("Buckets must be >= 1 and <= 255: " + buckets);
        }
        if (sorter == null) {
            throw new IllegalArgumentException("BytesRefSorter must not be null.");
        }
        this.sorter = sorter;
        this.buckets = buckets;
        this.suffixRAMLimitMB = suffixRAMLimitMB;
    }

    public void add(BytesRef utf8, int bucket) throws IOException {
        if (bucket < 0 || bucket >= this.buckets) {
            throw new IllegalArgumentException("Bucket outside of the allowed range [0, " + this.buckets + "): " + bucket);
        }
        this.scratch.growNoCopy(utf8.length + 10);
        this.scratch.clear();
        this.scratch.append((byte)bucket);
        this.scratch.append(utf8);
        this.sorter.add(this.scratch.get());
    }

    public FSTCompletion build() throws IOException {
        this.automaton = this.buildAutomaton(this.sorter);
        if (this.sorter instanceof Closeable) {
            ((Closeable)((Object)this.sorter)).close();
        }
        return new FSTCompletion(this.automaton);
    }

    private FST<Object> buildAutomaton(BytesRefSorter sorter) throws IOException {
        BytesRef entry;
        NoOutputs outputs = NoOutputs.getSingleton();
        Object empty = ((Outputs)outputs).getNoOutput();
        FSTCompiler<Object> fstCompiler = new FSTCompiler.Builder<Object>(FST.INPUT_TYPE.BYTE1, outputs).suffixRAMLimitMB(this.suffixRAMLimitMB).build();
        BytesRefBuilder scratch = new BytesRefBuilder();
        IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
        int count = 0;
        BytesRefIterator iter = sorter.iterator();
        while ((entry = iter.next()) != null) {
            ++count;
            if (scratch.get().compareTo(entry) == 0) continue;
            fstCompiler.add(Util.toIntsRef(entry, scratchIntsRef), empty);
            scratch.copyBytes(entry);
        }
        return count == 0 ? null : FST.fromFSTReader(fstCompiler.compile(), fstCompiler.getFSTReader());
    }
}

