/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.apache.lucene.search.uhighlight.CharArrayMatcher;
import org.apache.lucene.search.uhighlight.LabelledCharArrayMatcher;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class TokenStreamOffsetStrategy
extends AnalysisOffsetStrategy {
    private final CharArrayMatcher[] combinedAutomata;

    public TokenStreamOffsetStrategy(UHComponents components, Analyzer indexAnalyzer) {
        super(components, indexAnalyzer);
        assert (!components.phraseHelper().hasPositionSensitivity());
        this.combinedAutomata = TokenStreamOffsetStrategy.convertTermsToMatchers(components.terms(), components.automata());
    }

    private static CharArrayMatcher[] convertTermsToMatchers(BytesRef[] terms, CharArrayMatcher[] matchers) {
        CharArrayMatcher[] newAutomata = new CharArrayMatcher[terms.length + matchers.length];
        for (int i = 0; i < terms.length; ++i) {
            String termString = terms[i].utf8ToString();
            CharacterRunAutomaton a = new CharacterRunAutomaton(Automata.makeString(termString));
            newAutomata[i] = LabelledCharArrayMatcher.wrap(termString, a::run);
        }
        System.arraycopy(matchers, 0, newAutomata, terms.length, matchers.length);
        return newAutomata;
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        return new TokenStreamOffsetsEnum(this.tokenStream(content), this.combinedAutomata);
    }

    private static class TokenStreamOffsetsEnum
    extends OffsetsEnum {
        TokenStream stream;
        final CharArrayMatcher[] matchers;
        final CharTermAttribute charTermAtt;
        final OffsetAttribute offsetAtt;
        int currentMatch = -1;
        final BytesRef[] matchDescriptions;

        TokenStreamOffsetsEnum(TokenStream ts, CharArrayMatcher[] matchers) throws IOException {
            this.stream = ts;
            this.matchers = matchers;
            this.matchDescriptions = new BytesRef[matchers.length];
            this.charTermAtt = ts.addAttribute(CharTermAttribute.class);
            this.offsetAtt = ts.addAttribute(OffsetAttribute.class);
            ts.reset();
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (this.stream != null) {
                while (this.stream.incrementToken()) {
                    for (int i = 0; i < this.matchers.length; ++i) {
                        if (!this.matchers[i].match(this.charTermAtt.buffer(), 0, this.charTermAtt.length())) continue;
                        this.currentMatch = i;
                        return true;
                    }
                }
                this.stream.end();
                this.close();
            }
            return false;
        }

        @Override
        public int freq() throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public int startOffset() throws IOException {
            return this.offsetAtt.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.offsetAtt.endOffset();
        }

        @Override
        public BytesRef getTerm() throws IOException {
            if (this.matchDescriptions[this.currentMatch] == null) {
                this.matchDescriptions[this.currentMatch] = new BytesRef(this.matchers[this.currentMatch].toString());
            }
            return this.matchDescriptions[this.currentMatch];
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }
}

