/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.lucene.spatial.bbox.BBoxSimilarityValueSource;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class BBoxOverlapRatioValueSource
extends BBoxSimilarityValueSource {
    private final boolean isGeo;
    private final Rectangle queryExtent;
    private final double queryArea;
    private final double minSideLength;
    private final double queryTargetProportion;

    public BBoxOverlapRatioValueSource(ShapeValuesSource rectValueSource, boolean isGeo, Rectangle queryExtent, double queryTargetProportion, double minSideLength) {
        super(rectValueSource);
        this.isGeo = isGeo;
        this.minSideLength = minSideLength;
        this.queryExtent = queryExtent;
        this.queryArea = this.calcArea(queryExtent.getWidth(), queryExtent.getHeight());
        assert (this.queryArea >= 0.0);
        this.queryTargetProportion = queryTargetProportion;
        if (queryTargetProportion < 0.0 || queryTargetProportion > 1.0) {
            throw new IllegalArgumentException("queryTargetProportion must be >= 0 and <= 1");
        }
    }

    public BBoxOverlapRatioValueSource(ShapeValuesSource rectValueSource, Rectangle queryExtent) {
        this(rectValueSource, true, queryExtent, 0.25, 0.0);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BBoxOverlapRatioValueSource that = (BBoxOverlapRatioValueSource)o;
        if (Double.compare(that.minSideLength, this.minSideLength) != 0) {
            return false;
        }
        if (Double.compare(that.queryTargetProportion, this.queryTargetProportion) != 0) {
            return false;
        }
        return this.queryExtent.equals((Object)that.queryExtent);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queryExtent.hashCode();
        long temp = Double.doubleToLongBits(this.minSideLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.queryTargetProportion);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    protected String similarityDescription() {
        return this.queryExtent.toString() + "," + this.queryTargetProportion;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected double score(Rectangle target, AtomicReference<Explanation> exp) {
        double targetRatio;
        double width;
        double height;
        block22: {
            double qryEastRight;
            double qryEastLeft;
            double qryWestRight;
            double qryWestLeft;
            Rectangle b;
            Rectangle a;
            block23: {
                double right;
                double left;
                block24: {
                    double bottom;
                    double top = Math.min(this.queryExtent.getMaxY(), target.getMaxY());
                    height = top - (bottom = Math.max(this.queryExtent.getMinY(), target.getMinY()));
                    if (height < 0.0) {
                        if (exp != null) {
                            exp.set(Explanation.noMatch("No intersection", new Explanation[0]));
                        }
                        return 0.0;
                    }
                    width = 0.0;
                    a = this.queryExtent;
                    b = target;
                    if (a.getCrossesDateLine() != b.getCrossesDateLine()) break block23;
                    left = Math.max(a.getMinX(), b.getMinX());
                    right = Math.min(a.getMaxX(), b.getMaxX());
                    if (a.getCrossesDateLine()) break block24;
                    if (left <= right) {
                        width = right - left;
                        break block22;
                    } else if (!(!this.isGeo || Math.abs(a.getMinX()) != 180.0 && Math.abs(a.getMaxX()) != 180.0 || Math.abs(b.getMinX()) != 180.0 && Math.abs(b.getMaxX()) != 180.0)) {
                        width = 0.0;
                        break block22;
                    } else {
                        if (exp != null) {
                            exp.set(Explanation.noMatch("No intersection", new Explanation[0]));
                        }
                        return 0.0;
                    }
                }
                width = right - left + 360.0;
                break block22;
            }
            if (!a.getCrossesDateLine()) {
                a = target;
                b = this.queryExtent;
            }
            if ((qryWestLeft = Math.max(a.getMinX(), b.getMinX())) < (qryWestRight = b.getMaxX())) {
                width += qryWestRight - qryWestLeft;
            }
            if ((qryEastLeft = b.getMinX()) < (qryEastRight = Math.min(a.getMaxX(), b.getMaxX()))) {
                width += qryEastRight - qryEastLeft;
            }
            if (qryWestLeft > qryWestRight && qryEastLeft > qryEastRight) {
                if (exp != null) {
                    exp.set(Explanation.noMatch("No intersection", new Explanation[0]));
                }
                return 0.0;
            }
        }
        double intersectionArea = this.calcArea(width, height);
        double queryRatio = this.queryArea > 0.0 ? intersectionArea / this.queryArea : (this.queryExtent.getHeight() > 0.0 ? height / this.queryExtent.getHeight() : (this.queryExtent.getWidth() > 0.0 ? width / this.queryExtent.getWidth() : (this.queryExtent.relate((Shape)target).intersects() ? 1.0 : 0.0)));
        double targetArea = this.calcArea(target.getWidth(), target.getHeight());
        assert (targetArea >= 0.0);
        if (targetArea > 0.0) {
            targetRatio = intersectionArea / targetArea;
        } else if (target.getHeight() > 0.0) {
            targetRatio = height / target.getHeight();
        } else if (target.getWidth() > 0.0) {
            targetRatio = width / target.getWidth();
        } else {
            double d = targetRatio = target.relate((Shape)this.queryExtent).intersects() ? 1.0 : 0.0;
        }
        assert (queryRatio >= 0.0 && queryRatio <= 1.0) : queryRatio;
        assert (targetRatio >= 0.0 && targetRatio <= 1.0) : targetRatio;
        double queryFactor = queryRatio * this.queryTargetProportion;
        double targetFactor = targetRatio * (1.0 - this.queryTargetProportion);
        double score = queryFactor + targetFactor;
        if (exp != null) {
            String minSideDesc = this.minSideLength > 0.0 ? " (minSide=" + this.minSideLength + ")" : "";
            exp.set(Explanation.match((Number)Float.valueOf((float)score), this.getClass().getSimpleName() + ": queryFactor + targetFactor", Explanation.match((Number)Float.valueOf((float)intersectionArea), "IntersectionArea" + minSideDesc, Explanation.match((Number)Float.valueOf((float)width), "width", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)height), "height", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)this.queryTargetProportion), "queryTargetProportion", new Explanation[0])), Explanation.match((Number)Float.valueOf((float)queryFactor), "queryFactor", Explanation.match((Number)Float.valueOf((float)targetRatio), "ratio", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)this.queryArea), "area of " + String.valueOf(this.queryExtent) + minSideDesc, new Explanation[0])), Explanation.match((Number)Float.valueOf((float)targetFactor), "targetFactor", Explanation.match((Number)Float.valueOf((float)targetRatio), "ratio", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)targetArea), "area of " + String.valueOf(target) + minSideDesc, new Explanation[0]))));
        }
        return score;
    }

    private double calcArea(double width, double height) {
        return Math.max(this.minSideLength, width) * Math.max(this.minSideLength, height);
    }
}

