/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.StoredScriptSource;

@PublicApi(since="1.0.0")
public class GetStoredScriptResponse
extends ActionResponse
implements StatusToXContentObject {
    public static final ParseField _ID_PARSE_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField FOUND_PARSE_FIELD = new ParseField("found", new String[0]);
    public static final ParseField SCRIPT = new ParseField("script", new String[0]);
    private static final ConstructingObjectParser<GetStoredScriptResponse, String> PARSER = new ConstructingObjectParser<GetStoredScriptResponse, String>("GetStoredScriptResponse", true, (a, c) -> {
        String id = (String)a[0];
        boolean found = (Boolean)a[1];
        StoredScriptSource scriptSource = (StoredScriptSource)a[2];
        return found ? new GetStoredScriptResponse(id, scriptSource) : new GetStoredScriptResponse(id, null);
    });
    private String id;
    private StoredScriptSource source;

    public GetStoredScriptResponse(StreamInput in) throws IOException {
        super(in);
        this.source = in.readBoolean() ? new StoredScriptSource(in) : null;
        this.id = in.readString();
    }

    GetStoredScriptResponse(String id, StoredScriptSource source) {
        this.id = id;
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public StoredScriptSource getSource() {
        return this.source;
    }

    @Override
    public RestStatus status() {
        return this.source != null ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_ID_PARSE_FIELD.getPreferredName(), this.id);
        builder.field(FOUND_PARSE_FIELD.getPreferredName(), this.source != null);
        if (this.source != null) {
            builder.field(StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName());
            this.source.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static GetStoredScriptResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.source == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.source.writeTo(out);
        }
        out.writeString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStoredScriptResponse that = (GetStoredScriptResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), _ID_PARSE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.booleanValue(), FOUND_PARSE_FIELD, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> StoredScriptSource.fromXContent(p, true), SCRIPT, ObjectParser.ValueType.OBJECT);
    }
}

