/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.action.admin.indices.replication.SegmentReplicationShardStatsResponse;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsRequest;
import org.opensearch.action.admin.indices.replication.SegmentReplicationStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.SegmentReplicationPerGroupStats;
import org.opensearch.index.SegmentReplicationPressureService;
import org.opensearch.index.SegmentReplicationShardStats;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.SegmentReplicationTargetService;
import org.opensearch.transport.TransportService;

public class TransportSegmentReplicationStatsAction
extends TransportBroadcastByNodeAction<SegmentReplicationStatsRequest, SegmentReplicationStatsResponse, SegmentReplicationShardStatsResponse> {
    private final SegmentReplicationTargetService targetService;
    private final IndicesService indicesService;
    private final SegmentReplicationPressureService pressureService;

    @Inject
    public TransportSegmentReplicationStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, SegmentReplicationTargetService targetService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SegmentReplicationPressureService pressureService) {
        super("indices:monitor/segment_replication", clusterService, transportService, actionFilters, indexNameExpressionResolver, SegmentReplicationStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.targetService = targetService;
        this.pressureService = pressureService;
    }

    @Override
    protected SegmentReplicationShardStatsResponse readShardResult(StreamInput in) throws IOException {
        return new SegmentReplicationShardStatsResponse(in);
    }

    @Override
    protected SegmentReplicationStatsResponse newResponse(SegmentReplicationStatsRequest request, int totalShards, int successfulShards, int failedShards, List<SegmentReplicationShardStatsResponse> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        String[] shards = request.shards();
        List shardsToFetch = Arrays.stream(shards).map(Integer::valueOf).collect(Collectors.toList());
        HashMap<String, SegmentReplicationState> replicaStats = new HashMap<String, SegmentReplicationState>();
        HashMap<String, List> primaryStats = new HashMap<String, List>();
        for (SegmentReplicationShardStatsResponse response : responses) {
            if (response == null) continue;
            if (response.getReplicaStats() != null) {
                ShardRouting shardRouting = response.getReplicaStats().getShardRouting();
                if (shardsToFetch.isEmpty() || shardsToFetch.contains(shardRouting.shardId().getId())) {
                    replicaStats.putIfAbsent(shardRouting.allocationId().getId(), response.getReplicaStats());
                }
            }
            if (response.getPrimaryStats() == null) continue;
            ShardId shardId = response.getPrimaryStats().getShardId();
            if (!shardsToFetch.isEmpty() && !shardsToFetch.contains(shardId.getId())) continue;
            primaryStats.compute(shardId.getIndexName(), (k, v) -> {
                if (v == null) {
                    ArrayList<SegmentReplicationPerGroupStats> list = new ArrayList<SegmentReplicationPerGroupStats>();
                    list.add(response.getPrimaryStats());
                    return list;
                }
                v.add(response.getPrimaryStats());
                return v;
            });
        }
        Map<String, List<SegmentReplicationPerGroupStats>> replicationStats = primaryStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(groupStats -> this.updateGroupStats((SegmentReplicationPerGroupStats)groupStats, replicaStats)).collect(Collectors.toList())));
        return new SegmentReplicationStatsResponse(totalShards, successfulShards, failedShards, replicationStats, shardFailures);
    }

    @Override
    protected SegmentReplicationStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new SegmentReplicationStatsRequest(in);
    }

    @Override
    protected SegmentReplicationShardStatsResponse shardOperation(SegmentReplicationStatsRequest request, ShardRouting shardRouting) {
        ShardId shardId = shardRouting.shardId();
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
        if (!indexShard.indexSettings().isSegRepEnabledOrRemoteNode()) {
            return null;
        }
        if (shardRouting.primary()) {
            return new SegmentReplicationShardStatsResponse(this.pressureService.getStatsForShard(indexShard));
        }
        return new SegmentReplicationShardStatsResponse(this.getSegmentReplicationState(shardId, request.activeOnly()));
    }

    @Override
    protected ShardsIterator shards(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.routingTable().allShardsIncludingRelocationTargets(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, SegmentReplicationStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    private SegmentReplicationPerGroupStats updateGroupStats(SegmentReplicationPerGroupStats groupStats, Map<String, SegmentReplicationState> replicaStats) {
        Set updatedReplicaStats = groupStats.getReplicaStats().stream().peek(replicaStat -> replicaStat.setCurrentReplicationState(replicaStats.getOrDefault(replicaStat.getAllocationId(), null))).collect(Collectors.toSet());
        Set<SegmentReplicationShardStats> searchReplicaStats = this.computeSearchReplicaStats(groupStats.getShardId(), replicaStats);
        Set<SegmentReplicationShardStats> combinedStats = Stream.concat(updatedReplicaStats.stream(), searchReplicaStats.stream()).collect(Collectors.toSet());
        return new SegmentReplicationPerGroupStats(groupStats.getShardId(), combinedStats, groupStats.getRejectedRequestCount());
    }

    private Set<SegmentReplicationShardStats> computeSearchReplicaStats(ShardId shardId, Map<String, SegmentReplicationState> replicaStats) {
        return replicaStats.values().stream().filter(segmentReplicationState -> segmentReplicationState.getShardRouting().shardId().equals(shardId)).filter(segmentReplicationState -> segmentReplicationState.getShardRouting().isSearchOnly()).map(segmentReplicationState -> {
            ShardRouting shardRouting = segmentReplicationState.getShardRouting();
            SegmentReplicationShardStats segmentReplicationStats = this.computeSegmentReplicationShardStats(shardRouting);
            segmentReplicationStats.setCurrentReplicationState((SegmentReplicationState)segmentReplicationState);
            return segmentReplicationStats;
        }).collect(Collectors.toSet());
    }

    SegmentReplicationShardStats computeSegmentReplicationShardStats(ShardRouting shardRouting) {
        ShardId shardId = shardRouting.shardId();
        SegmentReplicationState completedSegmentReplicationState = this.targetService.getlatestCompletedEventSegmentReplicationState(shardId);
        SegmentReplicationState ongoingSegmentReplicationState = this.targetService.getOngoingEventSegmentReplicationState(shardId);
        return new SegmentReplicationShardStats(shardRouting.allocationId().getId(), 0L, this.calculateBytesRemainingToReplicate(ongoingSegmentReplicationState), 0L, this.getCurrentReplicationLag(ongoingSegmentReplicationState), this.getLastCompletedReplicationLag(completedSegmentReplicationState));
    }

    private SegmentReplicationState getSegmentReplicationState(ShardId shardId, boolean isActiveOnly) {
        if (isActiveOnly) {
            return this.targetService.getOngoingEventSegmentReplicationState(shardId);
        }
        return this.targetService.getSegmentReplicationState(shardId);
    }

    private long calculateBytesRemainingToReplicate(SegmentReplicationState ongoingSegmentReplicationState) {
        if (ongoingSegmentReplicationState == null) {
            return 0L;
        }
        return ongoingSegmentReplicationState.getIndex().fileDetails().stream().mapToLong(index -> index.length() - index.recovered()).sum();
    }

    private long getCurrentReplicationLag(SegmentReplicationState ongoingSegmentReplicationState) {
        return ongoingSegmentReplicationState != null ? ongoingSegmentReplicationState.getTimer().time() : 0L;
    }

    private long getLastCompletedReplicationLag(SegmentReplicationState completedSegmentReplicationState) {
        return completedSegmentReplicationState != null ? completedSegmentReplicationState.getTimer().time() : 0L;
    }
}

