/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexNodeResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexShardResponse;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

class ScaleIndexResponse
extends ActionResponse
implements ToXContent {
    private final Collection<ScaleIndexNodeResponse> nodeResponses;
    private final String failureReason;
    private final boolean hasFailures;

    ScaleIndexResponse(Collection<ScaleIndexNodeResponse> responses) {
        this.nodeResponses = responses;
        this.hasFailures = responses.stream().anyMatch(r -> r.getShardResponses().stream().anyMatch(s -> s.hasUncommittedOperations() || s.needsSync()));
        this.failureReason = this.buildFailureReason();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(new ArrayList<ScaleIndexNodeResponse>(this.nodeResponses));
        out.writeBoolean(this.hasFailures);
        out.writeOptionalString(this.failureReason);
    }

    boolean hasFailures() {
        return this.hasFailures;
    }

    String buildFailureReason() {
        if (!this.hasFailures) {
            return null;
        }
        StringBuilder reason = new StringBuilder();
        for (ScaleIndexNodeResponse nodeResponse : this.nodeResponses) {
            for (ScaleIndexShardResponse shardResponse : nodeResponse.getShardResponses()) {
                if (!shardResponse.hasUncommittedOperations() && !shardResponse.needsSync()) continue;
                reason.append("Shard ").append(shardResponse.getShardId()).append(" on node ").append(nodeResponse.getNode()).append(": ");
                if (shardResponse.hasUncommittedOperations()) {
                    reason.append("has uncommitted operations ");
                }
                if (shardResponse.needsSync()) {
                    reason.append("needs sync ");
                }
                reason.append("; ");
            }
        }
        return reason.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.failureReason != null) {
            builder.field("failure_reason", this.failureReason);
        }
        builder.endObject();
        return builder;
    }
}

