/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexClusterStateBuilder;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexNodeRequest;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexNodeResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexOperationValidator;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexRequest;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexShardResponse;
import org.opensearch.action.admin.indices.scale.searchonly.ScaleIndexShardSyncManager;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportService;

public class TransportScaleIndexAction
extends TransportClusterManagerNodeAction<ScaleIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportScaleIndexAction.class);
    public static final String NAME = "indices:admin/scale/search_only[s]";
    public static final String SHARD_SYNC_EXECUTOR = "management";
    private final AllocationService allocationService;
    private final IndicesService indicesService;
    private final ThreadPool threadPool;
    private final ScaleIndexOperationValidator validator;
    private final ScaleIndexClusterStateBuilder scaleIndexClusterStateBuilder;
    private final ScaleIndexShardSyncManager scaleIndexShardSyncManager;

    @Inject
    public TransportScaleIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService, IndicesService indicesService) {
        super("indices:admin/scale/search_only", transportService, clusterService, threadPool, actionFilters, ScaleIndexRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.indicesService = indicesService;
        this.threadPool = threadPool;
        this.validator = new ScaleIndexOperationValidator();
        this.scaleIndexClusterStateBuilder = new ScaleIndexClusterStateBuilder();
        this.scaleIndexShardSyncManager = new ScaleIndexShardSyncManager(clusterService, transportService, NAME);
        transportService.registerRequestHandler(NAME, "same", ScaleIndexNodeRequest::new, (request, channel, task) -> this.handleShardSyncRequest((ScaleIndexNodeRequest)request, channel));
    }

    @Override
    protected String executor() {
        return SHARD_SYNC_EXECUTOR;
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void clusterManagerOperation(ScaleIndexRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            String index = request.getIndex();
            if (request.isScaleDown()) {
                this.submitScaleDownTask(index, listener);
            } else {
                this.submitScaleUpTask(index, state, listener);
            }
        }
        catch (Exception e) {
            logger.error("Failed to execute cluster manager operation", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void submitScaleDownTask(String index, ActionListener<AcknowledgedResponse> listener) {
        HashMap<Index, ClusterBlock> blockedIndices = new HashMap<Index, ClusterBlock>();
        this.clusterService.submitStateUpdateTask("add-block-index-to-scale " + index, new AddBlockClusterStateUpdateTask(index, blockedIndices, listener));
    }

    private void proceedWithScaleDown(String index, Map<ShardId, String> primaryShardsNodes, ActionListener<AcknowledgedResponse> listener) {
        this.scaleIndexShardSyncManager.sendShardSyncRequests(index, primaryShardsNodes, ActionListener.wrap(responses -> this.handleShardSyncResponses((Collection<ScaleIndexNodeResponse>)responses, index, listener), listener::onFailure));
    }

    private void handleShardSyncResponses(Collection<ScaleIndexNodeResponse> responses, String index, ActionListener<AcknowledgedResponse> listener) {
        this.scaleIndexShardSyncManager.validateNodeResponses(responses, ActionListener.wrap(searchOnlyResponse -> this.finalizeScaleDown(index, listener), listener::onFailure));
    }

    private void finalizeScaleDown(String index, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("finalize-scale-down", new FinalizeScaleDownTask(index, listener));
    }

    void handleShardSyncRequest(ScaleIndexNodeRequest request, TransportChannel channel) {
        ClusterState state = this.clusterService.state();
        IndexMetadata indexMetadata = state.metadata().index(request.getIndex());
        if (indexMetadata == null) {
            throw new IllegalStateException("Index " + request.getIndex() + " not found");
        }
        IndexService indexService = this.getIndexService(indexMetadata);
        ChannelActionListener listener = new ChannelActionListener(channel, "sync_shard", request);
        this.syncShards(indexService, request.getShardIds(), listener);
    }

    private IndexService getIndexService(IndexMetadata indexMetadata) {
        IndexService indexService = this.indicesService.indexService(indexMetadata.getIndex());
        if (indexService == null) {
            throw new IllegalStateException("IndexService not found for index " + indexMetadata.getIndex().getName());
        }
        return indexService;
    }

    private void syncShards(IndexService indexService, List<ShardId> shardIds, final ActionListener<ScaleIndexNodeResponse> listener) {
        GroupedActionListener<ScaleIndexShardResponse> groupedActionListener = new GroupedActionListener<ScaleIndexShardResponse>(new ActionListener<Collection<ScaleIndexShardResponse>>(this){
            final /* synthetic */ TransportScaleIndexAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(Collection<ScaleIndexShardResponse> shardResponses) {
                listener.onResponse(new ScaleIndexNodeResponse(this.this$0.clusterService.localNode(), shardResponses.stream().toList()));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, shardIds.size());
        for (ShardId shardId : shardIds) {
            IndexShard shard = indexService.getShardOrNull(shardId.id());
            if (shard == null || !shard.routingEntry().primary()) {
                groupedActionListener.onFailure(new IllegalStateException("Attempting to scale down a replica shard"));
                break;
            }
            this.threadPool.executor(SHARD_SYNC_EXECUTOR).execute(() -> this.syncSingleShard(shard, groupedActionListener));
        }
    }

    void syncSingleShard(final IndexShard shard, final ActionListener<ScaleIndexShardResponse> listener) {
        shard.acquireAllPrimaryOperationsPermits(new ActionListener<Releasable>(this){

            @Override
            public void onResponse(Releasable releasable) {
                logger.info("Performing final sync and flush for shard {}", (Object)shard.shardId());
                try {
                    shard.sync();
                    shard.flush(new FlushRequest(new String[0]).force(true).waitIfOngoing(true));
                    shard.waitForRemoteStoreSync();
                    listener.onResponse(new ScaleIndexShardResponse(shard.shardId(), shard.isSyncNeeded(), shard.translogStats().getUncommittedOperations()));
                }
                catch (IOException e) {
                    listener.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, TimeValue.timeValueSeconds(30L));
    }

    private void submitScaleUpTask(String index, ClusterState currentState, ActionListener<AcknowledgedResponse> listener) {
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (!this.validator.validateScalePrerequisites(indexMetadata, index, listener, false)) {
            return;
        }
        this.clusterService.submitStateUpdateTask("scale-up-index", new ScaleUpClusterStateUpdateTask(index, listener));
    }

    @Override
    protected ClusterBlockException checkBlock(ScaleIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request.indicesOptions(), request.getIndex()));
    }

    class AddBlockClusterStateUpdateTask
    extends ClusterStateUpdateTask {
        private final String index;
        private final Map<Index, ClusterBlock> blockedIndices;
        private final ActionListener<AcknowledgedResponse> listener;

        AddBlockClusterStateUpdateTask(String index, Map<Index, ClusterBlock> blockedIndices, ActionListener<AcknowledgedResponse> listener) {
            super(Priority.URGENT);
            this.index = index;
            this.blockedIndices = blockedIndices;
            this.listener = listener;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            IndexMetadata indexMetadata = currentState.metadata().index(this.index);
            try {
                TransportScaleIndexAction.this.validator.validateScalePrerequisites(indexMetadata, this.index, this.listener, true);
                return TransportScaleIndexAction.this.scaleIndexClusterStateBuilder.buildScaleDownState(currentState, this.index, this.blockedIndices);
            }
            catch (Exception e) {
                return currentState;
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            if (oldState == newState) {
                this.listener.onResponse(new AcknowledgedResponse(true));
                return;
            }
            IndexMetadata indexMetadata = newState.metadata().index(this.index);
            if (indexMetadata != null) {
                Map<ShardId, String> primaryShardsNodes = TransportScaleIndexAction.this.scaleIndexShardSyncManager.getPrimaryShardAssignments(indexMetadata, newState);
                TransportScaleIndexAction.this.proceedWithScaleDown(this.index, primaryShardsNodes, this.listener);
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.error("Failed to process cluster state update for scale down", (Throwable)e);
            this.listener.onFailure(e);
        }
    }

    class FinalizeScaleDownTask
    extends ClusterStateUpdateTask {
        private final String index;
        private final ActionListener<AcknowledgedResponse> listener;

        FinalizeScaleDownTask(String index, ActionListener<AcknowledgedResponse> listener) {
            super(Priority.URGENT);
            this.index = index;
            this.listener = listener;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            return TransportScaleIndexAction.this.scaleIndexClusterStateBuilder.buildFinalScaleDownState(currentState, this.index);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(new AcknowledgedResponse(true));
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.error("Failed to finalize scale-down operation", (Throwable)e);
            this.listener.onFailure(e);
        }
    }

    private class ScaleUpClusterStateUpdateTask
    extends ClusterStateUpdateTask {
        private final String index;
        private final ActionListener<AcknowledgedResponse> listener;

        ScaleUpClusterStateUpdateTask(String index, ActionListener<AcknowledgedResponse> listener) {
            this.index = index;
            this.listener = listener;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            RoutingTable newRoutingTable = TransportScaleIndexAction.this.scaleIndexClusterStateBuilder.buildScaleUpRoutingTable(currentState, this.index);
            ClusterState tempState = ClusterState.builder(currentState).routingTable(newRoutingTable).build();
            ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(tempState.blocks());
            Metadata.Builder metadataBuilder = Metadata.builder(tempState.metadata());
            blocksBuilder.removeIndexBlockWithId(this.index, 20);
            IndexMetadata indexMetadata = tempState.metadata().index(this.index);
            Settings updatedSettings = Settings.builder().put(indexMetadata.getSettings()).put(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), false).build();
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(updatedSettings).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
            return TransportScaleIndexAction.this.allocationService.reroute(ClusterState.builder(tempState).blocks(blocksBuilder).metadata(metadataBuilder).build(), "restore indexing shards");
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(new AcknowledgedResponse(true));
        }

        @Override
        public void onFailure(String source, Exception e) {
            logger.error("Failed to execute cluster state update for scale up", (Throwable)e);
            this.listener.onFailure(e);
        }
    }
}

