/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.resume;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class ResumeIngestionRequest
extends AcknowledgedRequest<ResumeIngestionRequest>
implements IndicesRequest.Replaceable {
    public static final String RESET_SETTINGS = "reset_settings";
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private ResetSettings[] resetSettings;

    public ResumeIngestionRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.resetSettings = in.readArray(ResetSettings::new, ResetSettings[]::new);
    }

    public ResumeIngestionRequest(String[] indices) {
        this(indices, new ResetSettings[0]);
    }

    public ResumeIngestionRequest(String[] indices, ResetSettings[] resetSettings) {
        this.indices = indices;
        this.resetSettings = resetSettings;
    }

    @Override
    public ActionRequestValidationException validate() {
        boolean invalidResetSettingsFound;
        ActionRequestValidationException validationException = null;
        if (CollectionUtils.isEmpty(this.indices)) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        if (this.resetSettings.length > 0 && (invalidResetSettingsFound = Arrays.stream(this.resetSettings).anyMatch(resetSettings -> resetSettings.getShard() < 0 || resetSettings.getMode() == null || resetSettings.getValue() == null))) {
            validationException = ValidateActions.addValidationError("ResetSettings is missing either shard, mode or value", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ResumeIngestionRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ResumeIngestionRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeArray(this.resetSettings);
    }

    public ResetSettings[] getResetSettings() {
        return this.resetSettings;
    }

    public static ResumeIngestionRequest fromXContent(String[] indices, XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected START_OBJECT but got: " + String.valueOf((Object)parser.currentToken()));
        }
        ArrayList<ResetSettings> resetSettingsList = new ArrayList<ResetSettings>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String currentFieldName = parser.currentName();
            parser.nextToken();
            if (RESET_SETTINGS.equals(currentFieldName)) {
                if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                    throw new IllegalArgumentException("Expected START_ARRAY for 'reset_settings'");
                }
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    resetSettingsList.add(ResetSettings.fromXContent(parser));
                }
                continue;
            }
            throw new IllegalArgumentException("Unexpected field: " + currentFieldName);
        }
        return new ResumeIngestionRequest(indices, resetSettingsList.toArray(new ResetSettings[0]));
    }

    @ExperimentalApi
    public static class ResetSettings
    implements Writeable {
        private final int shard;
        private final ResetMode mode;
        private final String value;

        public ResetSettings(int shard, ResetMode mode, String value) {
            this.shard = shard;
            this.mode = mode;
            this.value = value;
        }

        public ResetSettings(StreamInput in) throws IOException {
            this.shard = in.readVInt();
            this.mode = in.readEnum(ResetMode.class);
            this.value = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shard);
            out.writeEnum(this.mode);
            out.writeString(this.value);
        }

        public int getShard() {
            return this.shard;
        }

        public ResetMode getMode() {
            return this.mode;
        }

        public String getValue() {
            return this.value;
        }

        public static ResetSettings fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("Expected START_OBJECT for ResetSettings but got: " + String.valueOf((Object)parser.currentToken()));
            }
            int shard = -1;
            ResetMode mode = null;
            String value = null;
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "shard": {
                        shard = parser.intValue();
                        continue block12;
                    }
                    case "mode": {
                        try {
                            mode = ResetMode.valueOf(parser.text().toUpperCase(Locale.ROOT));
                            continue block12;
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid value for 'mode': " + parser.text());
                        }
                    }
                    case "value": {
                        value = parser.text();
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unexpected field in ResetSettings: " + fieldName);
            }
            if (shard < 0 || mode == null || value == null) {
                throw new IllegalArgumentException("Missing required fields in ResetSettings: shard=" + shard + ", mode=" + String.valueOf(mode) + ", value=" + value);
            }
            return new ResetSettings(shard, mode, value);
        }

        @ExperimentalApi
        public static enum ResetMode {
            OFFSET,
            TIMESTAMP;

        }
    }
}

