/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.streamingingestion.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public record ShardIngestionState(String index, int shardId, String pollerState, String errorPolicy, boolean isPollerPaused, boolean isWriteBlockEnabled, String batchStartPointer) implements Writeable,
ToXContentFragment
{
    private static final String SHARD = "shard";
    private static final String POLLER_STATE = "poller_state";
    private static final String ERROR_POLICY = "error_policy";
    private static final String POLLER_PAUSED = "poller_paused";
    private static final String WRITE_BLOCK_ENABLED = "write_block_enabled";
    private static final String BATCH_START_POINTER = "batch_start_pointer";

    public ShardIngestionState() {
        this("", -1, "", "", false, false, "");
    }

    public ShardIngestionState(StreamInput in) throws IOException {
        this(in.readString(), in.readVInt(), in.readOptionalString(), in.readOptionalString(), in.readBoolean(), in.readBoolean(), in.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeOptionalString(this.pollerState);
        out.writeOptionalString(this.errorPolicy);
        out.writeBoolean(this.isPollerPaused);
        out.writeBoolean(this.isWriteBlockEnabled);
        out.writeString(this.batchStartPointer);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD, this.shardId);
        builder.field(POLLER_STATE, this.pollerState);
        builder.field(ERROR_POLICY, this.errorPolicy);
        builder.field(POLLER_PAUSED, this.isPollerPaused);
        builder.field(WRITE_BLOCK_ENABLED, this.isWriteBlockEnabled);
        builder.field(BATCH_START_POINTER, this.batchStartPointer);
        builder.endObject();
        return builder;
    }

    public static Map<String, List<ShardIngestionState>> groupShardStateByIndex(ShardIngestionState[] shardIngestionStates) {
        HashMap<String, List<ShardIngestionState>> shardIngestionStatesByIndex = new HashMap<String, List<ShardIngestionState>>();
        for (ShardIngestionState state : shardIngestionStates) {
            shardIngestionStatesByIndex.computeIfAbsent(state.index(), index -> new ArrayList());
            ((List)shardIngestionStatesByIndex.get(state.index())).add(state);
        }
        return shardIngestionStatesByIndex;
    }
}

